<?php

namespace Drupal\eaf\Plugin\EntityAttribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eaf\Attribute\EntityAttribute;
use Drupal\eaf\EntityAttributePluginBase;
use Drupal\Component\Utility\Html;

/**
 * Plugin implementation of the 'custom_class' setting.
 */
#[EntityAttribute(
  id: "entity_css_class",
  label: new TranslatableMarkup("Additional classes for the entity"),
  settings: [
    "weight" => 0,
  ]
)]
class EntityCssClass extends EntityAttributePluginBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(): array {
    $element = parent::formElement();

    return [
      '#type' => 'textfield',
      '#subtype' => 'css',
      '#description' => $this->t('Please separate multiple classes by spaces.'),
      '#size' => 32,
      '#weight' => 150,
    ] + $element;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultValue(): mixed {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function setValue($value, $attributes, $section = NULL): array {
    $v = explode(' ', $value ?? '');

    $classes = array_map(function ($part) {
      return Html::cleanCssIdentifier($part);
    }, $v);

    $attributes['classes'] = array_unique([...$classes]);
    $new_value = implode(' ', $attributes['classes']);
    $attributes = parent::setValue($new_value, $attributes, $section);

    return $attributes;
  }

}
