<?php

namespace Drupal\eaf\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'attributes raw formatter' formatter.
 */
#[FieldFormatter(
  id: 'field_attributes_raw_formatter',
  label: new TranslatableMarkup('Attributes raw formatter'),
  field_types: [
    'field_attributes_storage',
  ]
)]
class AttributesRawFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = [
        '#type' => 'html_tag',
        '#tag' => 'div',
        '#value' => $item->value,
      ];
    }

    return $elements;
  }

}
