<?php

/**
 * @file
 * Hooks specific to the Easy entity field module.
 */

/**
 * Remove the specified field type from the list of added new fields.
 *
 * @param array $field_types
 *   The field type to remove.
 *
 * @return array
 *   Remove field type.
 */
function hook_easy_entity_field_remove_field_type(array $field_types): array {
  $field_types['field_type_name'] = TRUE;
  return $field_types;
}

/**
 * Remove the specified entity type from the settings list.
 *
 * @param array $entity_types
 *   The entity type to remove.
 *
 * @return array
 *   Remove entity type.
 */
function hook_easy_entity_field_remove_entity_type(array $entity_types): array {
  $entity_types['entity_type_id'] = TRUE;
  return $entity_types;
}

/**
 * Respond to easy entity field storage save operations.
 *
 * This hook is invoked when an easy entity field configuration is saved.
 *
 * @param \Drupal\easy_entity_field\Entity\EasyEntityFieldInterface $entity
 *   The easy entity field entity that was saved.
 */
function hook_easy_entity_field_storage_save($entity) {
  // Respond to the saving of an easy entity field.
  \Drupal::logger('my_module')->info('Easy entity field @label was saved.', [
    '@label' => $entity->getLabel(),
  ]);
}

/**
 * Respond to easy entity field storage save operations for a specific field type.
 *
 * This hook is invoked when an easy entity field configuration is saved,
 * and allows modules to respond to specific field types.
 *
 * @param \Drupal\easy_entity_field\Entity\EasyEntityFieldInterface $entity
 *   The easy entity field entity that was saved.
 */
function hook_easy_entity_field_storage_save_FIELD_TYPE($entity) {
  // Respond to the saving of a specific field type.
  // Replace FIELD_TYPE with the actual field type, e.g., dynamic_entity_reference.
  \Drupal::logger('my_module')->info('Easy entity field @label of type @type was saved.', [
    '@label' => $entity->getLabel(),
    '@type' => $entity->getFieldType(),
  ]);
}
