# Contributing

Welcome! We're excited that you're interested in contributing to Entity Builder for Drupal 11. Whether you're a seasoned Drupal developer or just getting started, this guide will help you set up your environment and get involved.

## Setting Up Your Local Environment with DDEV

To make development easy and consistent, we recommend using [DDEV](https://ddev.com/get-started/) (version 1.24.0 or later). DDEV helps you quickly spin up a local Drupal environment.

## DDEV for your local environment

**Getting started:**

Run the following commands to set up your local environment with DDEV:

1. Create a new directory and enter it:
   ```shell
   mkdir eb-dev && cd eb-dev
   ```
2. Configure DDEV for a Drupal 11 project:
   ```shell
   ddev config --project-type=drupal11 --docroot=web --php-version=8.3 --corepack-enable
   ```
3. Add the Drupal Suite add-on:
   ```shell
   ddev add-on get lussoluca/ddev-drupal-suite
   ```
4. Use personal ssh keys for git operations:
   ```shell
   ddev auth ssh
   ```
5. Initialize Drupal (check core version first on https://www.drupal.org/project/drupal):
   ```shell
   ddev drupal-init 11.2.10
   ```
6. Install the Entity Builder module:
   ```shell
   ddev drupal-get-module eb 1.0.x
   ```

This is handy when you want to test the most recent updates or contribute to ongoing development.

Once everything is set up, you can launch your site with:
```shell
ddev launch
```
Or simply visit the URL that DDEV prints out.

To see all running services, use:
```shell
ddev describe
```

### Working with Related Modules

Entity Builder integrates well with other modules. You can add them to your development environment:

```shell
ddev drupal-get-module eb_field_group 1.0.x
ddev drupal-get-module eb_pathauto 1.0.x
ddev drupal-get-module eb_auto_entitylabel 1.0.x
```

This approach lets you work on integrations side-by-side, which is especially helpful for cross-module features, debugging, or reviewing changes.


### Working with Submodules

Entity Builder includes several submodules that extend its functionality. After installing the main module, you can enable the submodules you need:

```shell
ddev drush en eb_ui -y              # UI for managing definitions
ddev drush en eb_field_group -y     # Field Group integration
ddev drush en eb_pathauto -y        # Pathauto integration
ddev drush en eb_auto_entitylabel -y # Auto Entity Label integration
```

**Tip:**
If you omit the version when running `ddev drupal-get-module`, DDEV will fetch the module's default branch (usually the latest development version).

## Development Tools

Some tools are available to help you with development:

### `phpcs`

You can check your code for Drupal standards compliance using the `ddev phpcs` command. This tool validates your module and optionally fixes issues.

**Usage:**
```shell
ddev phpcs <module_name> [fix]
```
Replace `<module_name>` with the machine name of your module (e.g., `eb`).

**Examples:**
```shell
ddev phpcs eb           # Checks the 'eb' module for coding standards
ddev phpcs eb fix       # Automatically fixes fixable issues in the 'eb' module
ddev phpcs eb_ui        # Checks the 'eb_ui' submodule
```

**Notes:**
- The module name must start with a lowercase letter and only contain lowercase letters, numbers, and underscores.
- Entity Builder includes a custom `phpcs.xml` file that will be used for the check.
- The command provides a full report, summary, and source of any issues found.

### `phpstan`

You can analyze your code for bugs and potential issues using the `ddev phpstan` command. This tool runs PHPStan on your module and reports any problems found.

**Usage:**
```shell
ddev phpstan <module_name>
```
Replace `<module_name>` with the machine name of your module (e.g., `eb`).

**Example:**
```shell
ddev phpstan eb           # Analyzes the 'eb' module for bugs and issues
```

**Notes:**
- Entity Builder includes a custom `phpstan.neon` configuration file with project-specific settings.
- The analysis is run with a memory limit of 256M to avoid out-of-memory errors.

### `phpunit`

You can run tests for your module using the `ddev phpunit` command. This tool runs PHPUnit on your module and reports the results.

**Usage:**
```shell
ddev phpunit <module_name>
```
Replace `<module_name>` with the machine name of your module (e.g., `eb`).

**Examples:**
```shell
ddev phpunit eb           # Runs all tests for the 'eb' module
```

**Notes:**
- Entity Builder includes Unit, Kernel, and Functional tests.
- If your module has a custom `phpunit.xml.dist` file, it will be used for configuration.
- Temporary configuration files are cleaned up automatically after the tests run.

If you want to run a specific test, you can use the `--filter` option:
```shell
ddev phpunit eb --filter CreateBundleOperationTest
ddev phpunit eb --filter testValidateWithValidDefinition
```

## Ways to Contribute

- **Bug Reports**: Help identify and document issues
- **Feature Requests**: Suggest improvements and new features
- **Code Contributions**: Submit pull requests
- **Documentation**: Improve or translate documentation
- **Testing**: Test new releases and report findings

## Development Guidelines

### Adding Operations

1. Create operation class in `src/Plugin/EbOperation/`
2. Use `#[EbOperation]` attribute
3. Implement `validate()`, `preview()`, `execute()`, `rollback()`
4. Add tests in `tests/src/Unit/Plugin/EbOperation/`

### Adding Validators

1. Create validator class in `src/Plugin/EbValidator/`
2. Use `#[EbValidator]` attribute
3. Implement `validate()` method
4. Add tests

### Adding Extensions

1. Create new submodule (e.g., `eb_my_feature`)
2. Add extension plugin in `src/Plugin/EbExtension/`
3. Add operation plugins if needed
4. Add tests
5. Document in README.md

## Issue Guidelines

### Bug Reports

Include:

- Drupal version
- PHP version
- Entity Builder version
- Steps to reproduce
- Expected behavior
- Actual behavior
- Error messages (if any)
- Relevant YAML definition (if applicable)
