## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Recommended modules
- Configuration
- Documentation
- Maintainers


## INTRODUCTION

Entity Builder is a declarative entity architecture management module for
Drupal 11. Define bundles, fields, displays, field groups, menus, and roles
using flat YAML format with automatic dependency resolution and smart sync.

The primary use case for this module is to:

- **Define** entity architecture using flat, spreadsheet-friendly YAML
- **Import** definitions as reusable configuration entities
- **Validate** with two-stage validation before execution
- **Apply** changes with automatic dependency resolution
- **Rollback** operations with full undo support
- **Audit** all changes with comprehensive logging

Goals:

- A comprehensive entity architecture management solution for Drupal 11
- A stable, tested API for declarative entity configuration
- A pluggable/extensible API for custom integrations

## REQUIREMENTS

This module requires no modules outside of Drupal core.

For AG-Grid spreadsheet interface (recommended):
- Entity Builder AG-Grid (`eb_aggrid`) submodule
- AG-Grid Community library (33.0.0) via [Asset Packagist](https://asset-packagist.org/)

Optional modules for extended functionality:
- Field Group (`drupal/field_group`) - For `eb_field_group` extension
- Pathauto (`drupal/pathauto`) - For `eb_pathauto` extension
- Auto Entity Label (`drupal/auto_entitylabel`) - For `eb_auto_entitylabel` extension


## INSTALLATION

The installation of this module is like other Drupal modules.

1. If your site is [managed via Composer](https://www.drupal.org/node/2718229),
   use Composer to download the module running
   ```bash
   composer require drupal/eb
   ```

   For extension modules, install them separately:
   ```bash
   composer require drupal/eb_aggrid drupal/eb_field_group drupal/eb_pathauto drupal/eb_auto_entitylabel
   ```

2. **For AG-Grid interface** (recommended): Install the AG-Grid library via
   [Asset Packagist](https://asset-packagist.org/).

   First, configure Asset Packagist in your project's root `composer.json`:
   ```json
   {
     "repositories": [
       {"type": "composer", "url": "https://asset-packagist.org"}
     ],
     "extra": {
       "installer-types": ["npm-asset", "bower-asset"],
       "installer-paths": {
         "web/libraries/{$name}": ["type:npm-asset", "type:bower-asset"]
       }
     }
   }
   ```

   Then install the required packages:
   ```bash
   composer require oomphinc/composer-installers-extender
   composer require npm-asset/ag-grid-community:33.0.0
   ```

3. Enable the 'Entity Builder' module and desired sub-modules in 'Extend'.
   (`/admin/modules`)
   - `eb` - Core module (required)
   - `eb_ui` - YAML editor interface
   - `eb_aggrid` - AG-Grid spreadsheet interface (recommended, requires eb_ui and AG-Grid library)

4. Set up user permissions. (`/admin/people/permissions#module-eb`)


## CONFIGURATION

1. Navigate to **Configuration > Development > Entity Builder**
   (`/admin/config/development/eb`)

2. Import a YAML definition file or use the UI to create definitions.

3. Configure settings at **Configuration > Development > Entity Builder >
   Settings** (`/admin/config/development/eb/settings`).

### Quick Start (UI)

1. Enable the UI modules:
   ```bash
   # For YAML editor only:
   drush en eb_ui -y

   # For AG-Grid spreadsheet interface (recommended):
   # Note: Requires AG-Grid library - see INSTALLATION step 2
   drush en eb_aggrid -y
   ```

2. Navigate to **Configuration > Development > Entity Builder**
   (`/admin/config/development/eb`)

3. Click **Add definition** to create a new definition

4. Use the tabs to define your architecture:
   - **Bundles tab**: Add content types, vocabularies, media types
   - **Fields tab**: Add fields with type, label, widget, formatter
   - **Field Groups tab**: Organize fields into groups (requires `eb_field_group`)

5. Click **Validate** to check for errors

6. Click **Preview** to see planned operations with dependency resolution

7. Click **Apply** to execute and create your entities

### Quick Start (CLI)

```bash
drush eb:import <file>            # Import definition (review in UI first)
drush eb:apply <definition-id>    # Apply after review
drush eb:validate <file>          # Validate YAML file
drush eb:preview <file>           # Preview operations
drush eb:export <output>          # Export existing config to YAML
drush eb:rollback <id>            # Rollback operations
```

### Real-World Example

Try the included job board platform example:

```bash
# Import the definition (creates it for review, does not execute)
cd web/modules/contrib/eb
drush eb:import tests/fixtures/examples/job_board_platform.yml

# Go to the UI to review: /admin/config/development/eb
# Click on "Job Board Platform" to see bundles, fields, and field groups
# Click "Preview" to see all operations
# Click "Apply" when ready

# Or apply via Drush:
drush eb:apply job_board_platform
```

This example includes 11 bundles, 60+ fields, 40+ field groups, pathauto patterns, and auto entity labels.


## MAINTAINERS

Current maintainers:
- lexsoft - https://www.drupal.org/u/lexsoft
