# Entity Builder for Drupal 11

**Visual entity architecture management for Drupal 11.** Define bundles, fields, displays, and field groups using a spreadsheet-like UI or flat YAML format with automatic dependency resolution and smart sync.

## Why Entity Builder?

<div class="grid cards" markdown>

-   :material-view-grid:{ .lg .middle } **Visual UI**

    ---

    Spreadsheet-like grid interface with AG Grid - no YAML required

-   :material-table:{ .lg .middle } **Spreadsheet-Friendly**

    ---

    Flat format exports/imports easily to Google Sheets or Excel

-   :material-link-variant:{ .lg .middle } **Automatic Dependencies**

    ---

    No manual operation ordering required (Kahn's topological sort)

-   :material-sync:{ .lg .middle } **Smart Sync**

    ---

    Create new, update changed, skip unchanged - automatically

-   :material-file-document:{ .lg .middle } **Definition-Centric**

    ---

    Import once, apply multiple times, track with rollbacks

-   :material-shield-check:{ .lg .middle } **Production Ready**

    ---

    Two-stage validation, rollback support, and comprehensive error handling

-   :material-puzzle:{ .lg .middle } **Extensible**

    ---

    Plugin system for adding custom integrations

</div>

## Features Overview

| Category | Features |
|----------|----------|
| **UI** | Visual spreadsheet-like grid interface with tabs for bundles, fields, groups |
| **Format** | Flat YAML, spreadsheet-compatible, one row per item |
| **Workflow** | Definition-centric (create > review > apply), reusable definitions |
| **Operations** | 14 operation types: bundles, fields, displays, roles, menus |
| **Sync Modes** | sync (default), create_only, update_only, replace |
| **Validation** | Two-stage: operation-specific + cross-cutting validator plugins |
| **Rollback** | Full undo support using ContentEntity storage |
| **Audit Logging** | Two-tier logging: session tracking + operation details |
| **Discovery** | Runtime detection of field types, widgets, formatters |
| **CLI** | Complete Drush integration for automation and CI/CD |

## Quick Start

=== "Using the UI (Recommended)"

    1. **Install** Entity Builder and dependencies:
       ```bash
       composer require drupal/eb drupal/eb_aggrid drupal/eb_field_group drupal/eb_pathauto drupal/eb_auto_entitylabel
       ```

    2. **Install AG-Grid library** (requires [Asset Packagist](https://asset-packagist.org/) - see [Installation Guide](users/installation.md#entity-builder-ag-grid-eb_aggrid)):
       ```bash
       composer require npm-asset/ag-grid-community:33.0.0
       ```

    3. **Enable** all modules:
       ```bash
       drush en eb eb_ui eb_aggrid eb_field_group eb_pathauto eb_auto_entitylabel field_group pathauto auto_entitylabel -y && drush cr
       ```

        !!! tip "Recommended: AG-Grid Interface"
            The `eb_aggrid` module provides a powerful spreadsheet-like AG-Grid interface for managing definitions. **Strongly recommended** for the best visual editing experience. Requires the AG-Grid library via Asset Packagist.

    4. **Navigate** to **Configuration > Development > Entity Builder**

    5. **Create a definition** - Click "Add definition" and enter a label (e.g., "Job Board Platform")

    6. **Add bundles** - Use the Bundles tab to add content types and vocabularies:

        | Entity Type | Bundle ID | Label | Description |
        |-------------|-----------|-------|-------------|
        | taxonomy_term | job_categories | Job Categories | Main job classification |
        | taxonomy_term | job_types | Job Types | Full-time, part-time, etc. |
        | node | job_listing | Job Listing | Job postings with details |
        | node | company_profile | Company Profile | Employer profiles |

    7. **Add fields** - Use the Fields tab to add fields to bundles:

        | Entity Type | Bundle | Field Name | Field Type | Label | Widget |
        |-------------|--------|------------|------------|-------|--------|
        | node | job_listing | field_job_summary | text_with_summary | Job Summary | text_textarea_with_summary |
        | node | job_listing | field_job_category | entity_reference | Category | options_select |
        | node | job_listing | field_salary_min | integer | Min Salary | number |
        | node | job_listing | field_company | entity_reference | Company | entity_reference_autocomplete |

    8. **Add field groups** (optional) - Use the Field Groups tab to organize forms:

        | Bundle | Group Name | Label | Format | Parent |
        |--------|------------|-------|--------|--------|
        | job_listing | group_job_tabs | Job Info | tabs | - |
        | job_listing | group_job_basic | Basic Info | tab | group_job_tabs |
        | job_listing | group_job_compensation | Compensation | tab | group_job_tabs |

    9. **Preview and Apply** - Click Preview to see operations, then Apply to execute

=== "Using CLI"

    1. **Install** Entity Builder and dependencies:
       ```bash
       composer require drupal/eb drupal/eb_aggrid drupal/eb_field_group drupal/eb_pathauto drupal/eb_auto_entitylabel
       ```

    2. **Install AG-Grid library** (requires [Asset Packagist](https://asset-packagist.org/) - see [Installation Guide](users/installation.md#entity-builder-ag-grid-eb_aggrid)):
       ```bash
       composer require npm-asset/ag-grid-community:33.0.0
       ```

    3. **Enable** all modules:
       ```bash
       drush en eb eb_ui eb_aggrid eb_field_group eb_pathauto eb_auto_entitylabel field_group pathauto auto_entitylabel -y && drush cr
       ```

        !!! tip "Recommended: AG-Grid Interface"
            The `eb_aggrid` module provides a powerful spreadsheet-like AG-Grid interface for managing definitions. **Strongly recommended** for the best visual editing experience. Requires the AG-Grid library via Asset Packagist.

    4. **Import** the included job board example:
       ```bash
       drush eb:import tests/fixtures/examples/job_board_platform.yml
       ```

    5. **Review and Apply** - Either review in the UI at `/admin/config/development/eb` and click **Apply**, or apply via Drush:
       ```bash
       drush eb:apply job_board_platform
       ```

    See the [YAML Format Reference](users/yaml-format.md) for creating your own definitions.

## Real-World Example

Entity Builder includes a complete **Job Board Platform** example with:

| Component | Count | Details |
|-----------|-------|---------|
| **Taxonomies** | 7 | Categories, Types, Levels, Industries, Skills, Locations, Statuses |
| **Content Types** | 4 | Job Listing, Company Profile, Job Application, Company Review |
| **Fields** | 60+ | Text, entity references, images, files, lists, dates, booleans |
| **Field Groups** | 40+ | Tabbed layouts for organized forms and displays |
| **Display Modes** | Multiple | Default, teaser views with custom formatters |
| **Extensions** | All | Pathauto patterns, auto entity labels |

See `tests/fixtures/examples/job_board_platform.yml` for the complete definition.

## Architecture Diagram

```mermaid
flowchart TB
    subgraph Phase1["Phase 1: Data Entry"]
        UI[Entity Builder UI]
        YAML[YAML Import]
        UI --> DEF
        YAML --> DEF
        DEF[(EbDefinition<br/>Config Entity)]
    end

    subgraph Phase2["Phase 2: Apply Workflow"]
        ODB[OperationDataBuilder]
        DR[DependencyResolver]
        CD[ChangeDetector]
        VM[ValidationManager]
        OP[OperationProcessor]
        RM[RollbackManager]

        DEF --> ODB
        ODB --> DR
        DR --> CD
        CD --> VM
        VM --> OP
        OP --> RM
    end

    subgraph Result["Result"]
        Drupal[Drupal Entities]
        Log[(EbLog)]
        Rollback[(EbRollback)]

        OP --> Drupal
        OP --> Log
        OP --> Rollback
    end
```

## Available Extensions

| Extension | Requires | Adds |
|-----------|----------|------|
| **eb_ui** | - | Interactive YAML editor UI for managing definitions |
| **eb_aggrid** | `npm-asset/ag-grid-community:33.0.0` via [Asset Packagist](https://asset-packagist.org/) | AG-Grid spreadsheet interface (**strongly recommended**) |
| **eb_field_group** | `drupal/field_group` | `field_group_definitions` array, `group` column |
| **eb_pathauto** | `drupal/pathauto` | `pathauto_pattern` column on bundles |
| **eb_auto_entitylabel** | `drupal/auto_entitylabel` | `auto_entitylabel_*` columns on bundles |

## Getting Started

Ready to get started? See the [Quick Start Guide](users/quickstart.md) for installation and your first definition.

## Contributing

Entity Builder is open source. See the [Contributing Guide](contribute/index.md) to get involved.
