# Field Group Extension

The `eb_field_group` module adds support for organizing fields into visual groups within Entity Builder definitions.

**Project Page:** [https://www.drupal.org/project/eb_field_group](https://www.drupal.org/project/eb_field_group)

## Features

- Define field groups in YAML
- Support for fieldset, details, tabs, and HTML elements
- Nested group hierarchies
- Form and view display support
- Automatic dependency resolution

## Requirements

- Entity Builder (`eb`)
- Field Group (`drupal/field_group`)

## Installation

```bash
# Install the modules via Composer
composer require drupal/eb_field_group drupal/field_group

# Enable the modules
drush en field_group eb_field_group -y
```

## YAML Structure

### Field Group Definitions

```yaml
field_group_definitions:
  - entity_type: node
    bundle: article
    display_type: form          # form or view
    mode: default               # Display mode
    group_name: group_content   # Must start with group_
    label: Content
    format_type: fieldset       # Format type
    weight: 0
    format_settings:            # Optional format settings
      classes: "custom-class"
```

### Assigning Fields to Groups

Fields are assigned via `form_group` and `view_group` properties:

```yaml
field_definitions:
  - entity_type: node
    bundle: article
    field_name: field_body
    field_type: text_long
    label: Body
    form_group: group_content   # Form display group
    view_group: group_main      # View display group
```

## Format Types

### Fieldset

Simple bordered container:

```yaml
- group_name: group_basic
  format_type: fieldset
  format_settings:
    classes: "custom-class"
    description: "Help text"
```

### Details (Collapsible)

```yaml
- group_name: group_advanced
  format_type: details
  format_settings:
    open: false                 # Start collapsed
    classes: ""
    description: ""
```

### Tabs Container

Parent container for tab items:

```yaml
- group_name: group_tabs
  format_type: tabs
  format_settings:
    direction: horizontal       # horizontal or vertical
    width_breakpoint: 640       # Responsive breakpoint
```

### Tab Item

Must have a tabs parent:

```yaml
- group_name: group_tab_basic
  format_type: tab
  parent: group_tabs            # Required: parent tabs container
  format_settings:
    classes: ""
    description: "Tab description"
    formatter: "open"           # open or closed
```

### HTML Element

Semantic HTML wrapper:

```yaml
- group_name: group_header
  format_type: html_element
  format_settings:
    element: header             # div, section, article, header, footer, aside
    classes: "article-header"
    id: "article-header"
    label_element: h2           # Heading element for label
    show_label: true
```

## Complete Tabs Example

```yaml
version: "1.0"
id: product_form
label: Product Form Layout

bundle_definitions:
  - entity_type: node
    bundle_id: product
    label: Product

field_definitions:
  # Basic Info Tab Fields
  - entity_type: node
    bundle: product
    field_name: field_sku
    field_type: string
    label: SKU
    form_group: group_tab_basic
    weight: 0

  - entity_type: node
    bundle: product
    field_name: field_description
    field_type: text_long
    label: Description
    form_group: group_tab_basic
    weight: 1

  # Pricing Tab Fields
  - entity_type: node
    bundle: product
    field_name: field_price
    field_type: decimal
    label: Price
    form_group: group_tab_pricing
    weight: 0

  - entity_type: node
    bundle: product
    field_name: field_sale_price
    field_type: decimal
    label: Sale Price
    form_group: group_tab_pricing
    weight: 1

field_group_definitions:
  # Tabs Container
  - entity_type: node
    bundle: product
    display_type: form
    mode: default
    group_name: group_main_tabs
    label: Product Information
    format_type: tabs
    format_settings:
      direction: horizontal
    weight: 0

  # Basic Info Tab
  - entity_type: node
    bundle: product
    display_type: form
    mode: default
    group_name: group_tab_basic
    label: Basic Information
    format_type: tab
    parent: group_main_tabs
    weight: 0

  # Pricing Tab
  - entity_type: node
    bundle: product
    display_type: form
    mode: default
    group_name: group_tab_pricing
    label: Pricing
    format_type: tab
    parent: group_main_tabs
    weight: 1
```

## Nested Groups

Groups can be nested to create complex layouts:

```yaml
field_group_definitions:
  # Root tabs
  - group_name: group_tabs
    format_type: tabs
    weight: 0

  # Tab 1
  - group_name: group_tab_content
    format_type: tab
    parent: group_tabs
    weight: 0

  # Fieldset inside Tab 1
  - group_name: group_basic_info
    format_type: fieldset
    parent: group_tab_content
    weight: 0

  # Another fieldset inside Tab 1
  - group_name: group_media
    format_type: fieldset
    parent: group_tab_content
    weight: 1
```

## Dependencies

The extension automatically handles dependencies:

- Field group depends on bundle
- Field group depends on display configuration
- Field group depends on child fields
- Nested groups depend on parent groups

## Operations

| Operation | Description |
|-----------|-------------|
| `create_field_group` | Create a new field group |
| `update_field_group` | Update existing field group |
| `delete_field_group` | Delete a field group |

## Change Detection

In sync mode, field groups are compared by:

- Label
- Format type
- Parent group
- Weight
- Format settings

Unchanged groups are skipped.

## Export

When exporting definitions, existing field groups are included:

```bash
drush eb:generate my_site --entity-type=node --bundle=article
```

The exported YAML will include:
- `field_group_definitions` array
- `form_group`/`view_group` assignments on fields

## Troubleshooting

### "Field group module not installed"

```bash
composer require drupal/field_group
drush en field_group -y
```

### Groups Not Showing

1. Verify field_group module is enabled
2. Check that fields are assigned to groups
3. Clear cache: `drush cr`

### Tab Content Empty

Ensure fields have `form_group` set to the tab's `group_name`, not the tabs container.
