<?php

declare(strict_types=1);

namespace Drupal\eb\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an Entity Builder Extension plugin attribute.
 *
 * Extension plugins allow modules to extend YAML parsing capabilities
 * through a single plugin class instead of multiple hooks.
 *
 * @see \Drupal\eb\Plugin\EbExtensionInterface
 * @see \Drupal\eb\Plugin\EbExtensionBase
 * @see \Drupal\eb\Plugin\EbExtensionManager
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EbExtension extends Plugin {

  /**
   * Constructor.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   Human-readable label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   Description of the extension.
   * @param array $yaml_keys
   *   YAML keys this extension handles (e.g., ['field_groups']).
   * @param array $operations
   *   Operation IDs this extension provides (e.g., ['create_field_group']).
   * @param array $module_dependencies
   *   Required Drupal modules (e.g., ['field_group']).
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly array $yaml_keys = [],
    public readonly array $operations = [],
    public readonly array $module_dependencies = [],
    public readonly ?string $deriver = NULL,
  ) {}

}
