<?php

declare(strict_types=1);

namespace Drupal\eb\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attribute for Entity Builder operation plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class EbOperation extends Plugin {

  /**
   * Constructor.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The plugin label.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The plugin description.
   * @param string $operationType
   *   The operation type (create, update, delete).
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly string $operationType = 'create',
    public readonly ?string $deriver = NULL,
  ) {}

}
