<?php

namespace Drupal\eb\Drush\Commands;

use Drupal\eb\Service\DiscoveryServiceInterface;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Drush commands for Entity Builder discovery operations.
 */
final class EbDiscoveryCommands extends DrushCommands {

  /**
   * Constructor.
   *
   * @param \Drupal\eb\Service\DiscoveryServiceInterface $discoveryService
   *   The discovery service.
   */
  public function __construct(
    protected DiscoveryServiceInterface $discoveryService,
  ) {
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new self(
      $container->get('eb.discovery_service'),
    );
  }

  /**
   * Show discovered capabilities.
   */
  #[CLI\Command(name: 'eb:discovery', aliases: ['ebd'])]
  #[CLI\Usage(name: 'eb:discovery', description: 'Show all discovered capabilities')]
  public function discovery(): void {
    $field_types = $this->discoveryService->getAllFieldTypes();
    $widgets = $this->discoveryService->getAllWidgets();
    $formatters = $this->discoveryService->getAllFormatters();
    $entity_types = $this->discoveryService->getFieldableEntityTypes();

    $this->output()->writeln('');
    $this->output()->writeln(dt('Discovered Capabilities:'));
    $this->output()->writeln(dt('  Field Types: @count', ['@count' => count($field_types)]));
    $this->output()->writeln(dt('  Widgets: @count', ['@count' => count($widgets)]));
    $this->output()->writeln(dt('  Formatters: @count', ['@count' => count($formatters)]));
    $this->output()->writeln(dt('  Entity Types: @count', ['@count' => count($entity_types)]));
    $this->output()->writeln('');
  }

}
