<?php

declare(strict_types=1);

namespace Drupal\eb\Event;

/**
 * Defines events for Entity Builder operations.
 */
final class OperationEvents {

  /**
   * Event dispatched before operation validation.
   *
   * @Event
   *
   * @var string
   */
  public const PRE_VALIDATE = 'eb.operation.pre_validate';

  /**
   * Event dispatched after operation validation.
   *
   * @Event
   *
   * @var string
   */
  public const POST_VALIDATE = 'eb.operation.post_validate';

  /**
   * Event dispatched before operation execution.
   *
   * @Event
   *
   * @var string
   */
  public const PRE_EXECUTE = 'eb.operation.pre_execute';

  /**
   * Event dispatched after operation execution.
   *
   * @Event
   *
   * @var string
   */
  public const POST_EXECUTE = 'eb.operation.post_execute';

}
