<?php

declare(strict_types=1);

namespace Drupal\eb\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\eb\PluginInterfaces\OperationInterface;

/**
 * Event dispatched before operation validation.
 */
final class OperationPreValidateEvent extends Event {

  /**
   * Constructor.
   *
   * @param \Drupal\eb\PluginInterfaces\OperationInterface $operation
   *   The operation being validated.
   */
  public function __construct(
    protected OperationInterface $operation,
  ) {}

  /**
   * Gets the operation.
   */
  public function getOperation(): OperationInterface {
    return $this->operation;
  }

}
