<?php

namespace Drupal\eb\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\eb\Service\RollbackManagerInterface;

/**
 * Hook implementations for eb module.
 *
 * Uses Drupal 11 OOP Hook Class pattern with #[Hook] attributes.
 */
class EbHooks {

  /**
   * Constructor.
   *
   * @param \Drupal\eb\Service\RollbackManagerInterface $rollbackManager
   *   The rollback manager service.
   */
  public function __construct(
    protected RollbackManagerInterface $rollbackManager,
  ) {}

  /**
   * Cascade delete rollbacks when a definition is deleted.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The deleted entity.
   */
  #[Hook('entity_delete')]
  public function onEntityDelete(EntityInterface $entity): void {
    // Only process EbDefinition deletions.
    if ($entity->getEntityTypeId() !== 'eb_definition') {
      return;
    }

    $definitionId = $entity->id();
    if ($definitionId !== NULL) {
      $this->rollbackManager->deleteByDefinition((string) $definitionId);
    }
  }

}
