<?php

declare(strict_types=1);

namespace Drupal\eb\PluginInterfaces;

/**
 * Combined interface for operations with full functionality.
 *
 * This interface combines the base OperationInterface with both
 * PreviewableOperationInterface and ReversibleOperationInterface,
 * representing operations that support preview and rollback.
 *
 * All current Entity Builder operations implement this full interface.
 * The separate interfaces (PreviewableOperationInterface,
 * ReversibleOperationInterface) allow type-hinting for specific capabilities.
 *
 * @see \Drupal\eb\PluginBase\OperationBase
 */
interface FullOperationInterface extends PreviewableOperationInterface, ReversibleOperationInterface {
  // This interface combines PreviewableOperationInterface and
  // ReversibleOperationInterface. No additional methods needed.
}
