<?php

declare(strict_types=1);

namespace Drupal\eb\PluginInterfaces;

use Drupal\eb\Result\RollbackResult;

/**
 * Interface for operations that support rollback functionality.
 *
 * Operations implementing this interface can undo their changes after
 * execution. This requires the operation to store rollback data during
 * execution that can be used to reverse the changes.
 *
 * @see \Drupal\eb\Service\RollbackManager
 */
interface ReversibleOperationInterface extends OperationInterface {

  /**
   * Rolls back a previously executed operation.
   *
   * @return \Drupal\eb\Result\RollbackResult
   *   Rollback result with restored entities and messages.
   *
   * @throws \Drupal\eb\Exception\RollbackException
   *   If rollback fails.
   */
  public function rollback(): RollbackResult;

}
