<?php

declare(strict_types=1);

namespace Drupal\eb\PluginInterfaces;

use Drupal\eb\Result\ValidationResult;

/**
 * Interface for Entity Builder validator plugins.
 */
interface ValidatorInterface {

  /**
   * Validates operation data.
   *
   * @param array<string, mixed> $data
   *   Operation data to validate.
   *
   * @return \Drupal\eb\Result\ValidationResult
   *   Validation result.
   */
  public function validate(array $data): ValidationResult;

}
