# Contributing to Entity Builder

Thank you for your interest in contributing to Entity Builder!

For complete setup instructions and contribution guidelines, see the [CONTRIBUTING.md](https://github.com/your-org/entity-builder/blob/main/CONTRIBUTING.md) file in the repository root.

## Quick Start

### Set Up Development Environment with DDEV

```shell
# Create and configure project
mkdir eb-dev && cd eb-dev
ddev config --project-type=drupal11 --docroot=web --php-version=8.3 --corepack-enable
ddev add-on get lussoluca/ddev-drupal-suite
ddev auth ssh

# Initialize Drupal and install Entity Builder
ddev drupal-init 11.2.10
ddev drupal-get-module eb 1.0.x

# Launch the site
ddev launch
```

### Working with Related Modules

Entity Builder integrates well with other modules. You can add them to your development environment:

```shell
ddev drupal-get-module eb_field_group 1.0.x
ddev drupal-get-module eb_pathauto 1.0.x
ddev drupal-get-module eb_auto_entitylabel 1.0.x
```

This approach lets you work on integrations side-by-side, which is especially helpful for cross-module features, debugging, or reviewing changes.


### Working with Submodules

Entity Builder includes several submodules that extend its functionality. After installing the main module, you can enable the submodules you need:

```shell
ddev drush en eb_ui -y              # UI for managing definitions
ddev drush en eb_field_group -y     # Field Group integration
ddev drush en eb_pathauto -y        # Pathauto integration
ddev drush en eb_auto_entitylabel -y # Auto Entity Label integration
```

**Tip:**
If you omit the version when running `ddev drupal-get-module`, DDEV will fetch the module's default branch (usually the latest development version).

## Development Tools

### Code Standards Check

```shell
ddev phpcs eb           # Check coding standards
ddev phpcs eb fix       # Auto-fix issues
```

### Static Analysis

```shell
ddev phpstan eb         # Analyze for bugs and issues
```

### Run Tests

```shell
ddev phpunit eb                              # Run all tests
ddev phpunit eb --filter CreateBundleOperationTest  # Run specific test
```

## Ways to Contribute

| Type | Description |
|------|-------------|
| **Bug Reports** | Help identify and document issues |
| **Feature Requests** | Suggest improvements and new features |
| **Code Contributions** | Submit pull requests |
| **Documentation** | Improve or translate documentation |
| **Testing** | Test new releases and report findings |

## Issue Guidelines

### Bug Reports

Include:

- Drupal and PHP versions
- Entity Builder version
- Steps to reproduce
- Expected vs actual behavior
- Error messages and relevant YAML definitions
