# Auto Entity Label Extension

The `eb_auto_entitylabel` module adds automatic label generation support to Entity Builder bundle definitions.

**Project Page:** [https://www.drupal.org/project/eb_auto_entitylabel](https://www.drupal.org/project/eb_auto_entitylabel)

## Features

- Configure automatic entity labels in YAML
- Token-based label patterns
- Multiple status modes (enabled, optional, prefilled)
- Sync mode support

## Requirements

- Entity Builder (`eb`)
- Automatic Entity Label (`drupal/auto_entitylabel`)
- Token (`drupal/token`)

## Installation

```bash
# Install the modules via Composer
composer require drupal/eb_auto_entitylabel drupal/auto_entitylabel

# Enable the modules
drush en auto_entitylabel eb_auto_entitylabel -y
```

## YAML Structure

Add `auto_entitylabel_status` and `auto_entitylabel_pattern` to bundle definitions:

```yaml
bundle_definitions:
  - entity_type: node
    bundle_id: event
    label: Event
    auto_entitylabel_status: enabled
    auto_entitylabel_pattern: "[node:field_event_date:date:short] - [node:field_event_name]"
```

## Status Modes

| Status | Title Field | Behavior |
|--------|-------------|----------|
| `disabled` | Visible, required | Normal Drupal behavior |
| `enabled` | Hidden | Label auto-generated, users cannot edit |
| `optional` | Visible, optional | Users can enter or leave blank for auto |
| `prefilled` | Visible, prefilled | Auto-generated but editable |

## Complete Example

```yaml
version: "1.0"
id: event_system
label: Event System

bundle_definitions:
  - entity_type: node
    bundle_id: event
    label: Event
    auto_entitylabel_status: enabled
    auto_entitylabel_pattern: "[node:field_event_date:date:short] - [node:field_venue] - [node:field_event_type]"

  - entity_type: node
    bundle_id: registration
    label: Registration
    auto_entitylabel_status: enabled
    auto_entitylabel_pattern: "Registration: [node:field_attendee:entity:name] for [node:field_event:entity:title]"

  - entity_type: taxonomy_term
    bundle_id: event_type
    label: Event Type
    auto_entitylabel_status: disabled

field_definitions:
  - entity_type: node
    bundle: event
    field_name: field_event_date
    field_type: datetime
    label: Event Date

  - entity_type: node
    bundle: event
    field_name: field_venue
    field_type: string
    label: Venue

  - entity_type: node
    bundle: event
    field_name: field_event_type
    field_type: entity_reference
    label: Event Type
    field_storage_settings:
      target_type: taxonomy_term
```

## Common Patterns

### Date-Based Labels

```yaml
# Event with date
auto_entitylabel_pattern: "[node:field_event_date:date:medium] - [node:field_name]"
# Result: "January 15, 2024 - Annual Conference"

# Invoice with timestamp
auto_entitylabel_pattern: "INV-[node:created:custom:Ymd]-[node:nid]"
# Result: "INV-20240115-42"
```

### Reference-Based Labels

```yaml
# Order with customer
auto_entitylabel_pattern: "Order #[node:nid] - [node:field_customer:entity:name]"
# Result: "Order #123 - John Smith"

# Comment on article
auto_entitylabel_pattern: "Comment on [node:field_article:entity:title]"
# Result: "Comment on My Blog Post"
```

### Counter-Based Labels

```yaml
# Sequential numbering
auto_entitylabel_pattern: "TICKET-[node:nid]"
# Result: "TICKET-456"
```

## Operations

| Operation | Description |
|-----------|-------------|
| `configure_auto_entitylabel` | Creates/updates auto_entitylabel configuration |

## Change Detection

In sync mode:

- Configuration created if missing
- Configuration updated if status or pattern changed
- Configuration skipped if unchanged

## UI Integration

When `eb_ui` is enabled, two columns appear in the Bundles tab:

- **Auto Label Status**: Dropdown with status options
- **Auto Label Pattern**: Text field for token pattern

## Configuration Storage

Auto entity label configuration is stored in Drupal config:

```
auto_entitylabel.settings.{entity_type}.{bundle}
```

Example: `auto_entitylabel.settings.node.event`

## Token Reference

Common tokens for labels:

### Node Tokens

- `[node:nid]` - Node ID
- `[node:created:date:short]` - Creation date
- `[node:field_*]` - Field values
- `[node:field_*:entity:name]` - Referenced entity name

### Term Tokens

- `[term:tid]` - Term ID
- `[term:vocabulary]` - Vocabulary name

### User Tokens

- `[user:uid]` - User ID
- `[user:name]` - Username

## Troubleshooting

### Labels Not Generating

1. Verify status is not `disabled`
2. Check pattern uses valid tokens
3. Save content to trigger generation

### Tokens Not Resolving

1. Check token syntax (square brackets)
2. Verify referenced fields exist
3. Ensure token module is enabled
4. Check for typos in field names

### Title Field Still Visible

- For `enabled` status: title should be hidden
- Clear cache: `drush cr`
- Check form display settings
