# Pathauto Extension

The `eb_pathauto` module adds URL alias pattern support to Entity Builder bundle definitions.

**Project Page:** [https://www.drupal.org/project/eb_pathauto](https://www.drupal.org/project/eb_pathauto)

## Features

- Define pathauto patterns in YAML
- Automatic pattern creation for bundles
- Token-based URL patterns
- Sync mode support

## Requirements

- Entity Builder (`eb`)
- Pathauto (`drupal/pathauto`)
- Token (`drupal/token`)

## Installation

```bash
# Install the modules via Composer
composer require drupal/eb_pathauto drupal/pathauto

# Enable the modules
drush en pathauto eb_pathauto -y
```

## YAML Structure

Add `pathauto_pattern` to bundle definitions:

```yaml
bundle_definitions:
  - entity_type: node
    bundle_id: article
    label: Article
    pathauto_pattern: /blog/[node:title]

  - entity_type: node
    bundle_id: product
    label: Product
    pathauto_pattern: /products/[node:field_category:entity:name]/[node:title]

  - entity_type: taxonomy_term
    bundle_id: category
    label: Category
    pathauto_pattern: /categories/[term:name]
```

## Common Token Patterns

### Node Patterns

| Pattern | Example URL |
|---------|-------------|
| `[node:title]` | `/my-article-title` |
| `/blog/[node:title]` | `/blog/my-article-title` |
| `/[node:created:custom:Y]/[node:created:custom:m]/[node:title]` | `/2024/01/my-article` |
| `/[node:field_category:entity:name]/[node:title]` | `/technology/my-article` |

### Taxonomy Term Patterns

| Pattern | Example URL |
|---------|-------------|
| `[term:name]` | `/my-category` |
| `/categories/[term:name]` | `/categories/my-category` |
| `/[term:vocabulary]/[term:name]` | `/tags/my-tag` |
| `/[term:parents:join-path]/[term:name]` | `/parent/child/grandchild` |

### User Patterns

| Pattern | Example URL |
|---------|-------------|
| `/users/[user:name]` | `/users/johndoe` |
| `/profiles/[user:uid]` | `/profiles/123` |

## Complete Example

```yaml
version: "1.0"
id: blog_with_urls
label: Blog with URL Patterns

bundle_definitions:
  - entity_type: taxonomy_term
    bundle_id: blog_category
    label: Blog Categories
    pathauto_pattern: /blog/category/[term:name]

  - entity_type: node
    bundle_id: blog_post
    label: Blog Post
    pathauto_pattern: /blog/[node:field_category:entity:name]/[node:title]

field_definitions:
  - entity_type: node
    bundle: blog_post
    field_name: field_category
    field_type: entity_reference
    label: Category
    field_storage_settings:
      target_type: taxonomy_term
    field_config_settings:
      handler_settings:
        target_bundles:
          blog_category: blog_category
```

## Operations

| Operation | Description |
|-----------|-------------|
| `create_pathauto_pattern` | Creates a pathauto pattern entity |

## Pattern ID Generation

Pattern IDs are automatically generated:

```
{entity_type}_{bundle}_pattern

Examples:
- node_article_pattern
- taxonomy_term_category_pattern
```

## Change Detection

In sync mode:

- Pattern created if missing
- Pattern updated if pattern string changed
- Pattern skipped if unchanged

## UI Integration

When `eb_ui` is enabled, a "Pathauto Pattern" column appears in the Bundles tab.

## Token Reference

Available tokens depend on the entity type and installed modules. Common sources:

- **Node**: title, nid, created, changed, author, fields
- **Term**: name, tid, vocabulary, parents
- **User**: name, uid, mail

View all available tokens at `/admin/help/token`.

## Troubleshooting

### Patterns Not Creating URLs

1. Verify pathauto module is enabled
2. Check pattern exists: `/admin/config/search/path/patterns`
3. Ensure content is being saved (patterns apply on save)

### Invalid Tokens

1. Check token syntax (brackets required)
2. Verify token module is enabled
3. Check field machine names match tokens

### Duplicate URL Aliases

Pathauto handles duplicates automatically by appending numbers:
- `/blog/my-post`
- `/blog/my-post-0`
- `/blog/my-post-1`
