# Installation Guide

Complete installation instructions for Entity Builder and its extensions.

## Requirements

| Requirement | Version |
|-------------|---------|
| Drupal | 11.x |
| PHP | 8.3+ |
| Composer | 2.x |

## Core Module Installation

### Via Composer (Recommended)

```bash
composer require drupal/eb
drush en eb -y
drush cr
```

### Via Drupal UI

1. Download the module from drupal.org
2. Extract to `web/modules/contrib/eb`
3. Navigate to **Extend** (`/admin/modules`)
4. Enable "Entity Builder"
5. Clear caches

## Extension Modules

Entity Builder has several extension modules that add functionality.

### Quick Install All Extensions

To install Entity Builder with all extensions in one go:

!!! tip "AG-Grid Requirement"
    The `eb_aggrid` module requires the AG-Grid library via Asset Packagist. See the [eb_aggrid section](#entity-builder-ag-grid-eb_aggrid) below for Asset Packagist setup.

```bash
# Install Entity Builder and extension modules
composer require drupal/eb drupal/eb_aggrid drupal/eb_field_group drupal/eb_pathauto drupal/eb_auto_entitylabel

# Install AG-Grid library (requires Asset Packagist - see eb_aggrid section)
composer require npm-asset/ag-grid-community:33.0.0

# Enable Entity Builder and all extensions
drush en eb eb_ui eb_aggrid eb_field_group eb_pathauto eb_auto_entitylabel -y

# Enable contrib dependencies
drush en field_group pathauto auto_entitylabel -y

# Clear cache
drush cr
```

### Individual Extension Installation

### Entity Builder UI (eb_ui)

Provides the base UI functionality with a YAML editor and shared API endpoints.

```bash
drush en eb_ui -y
```

**Features:**

- CodeMirror-based YAML editor
- Live validation
- Preview before apply
- Export/Import capabilities

### Entity Builder AG-Grid (eb_aggrid)

Provides a powerful AG-Grid spreadsheet interface for visual editing. **Strongly recommended** for the best user experience.

!!! note "Library Requirement"
    eb_aggrid requires the AG-Grid Community library (33.0.0) which must be installed via [Asset Packagist](https://asset-packagist.org/).

#### Step 1: Configure Asset Packagist (if not already done)

Add the following to your project's root `composer.json`:

```json
{
  "repositories": [
    {
      "type": "composer",
      "url": "https://asset-packagist.org"
    }
  ],
  "extra": {
    "installer-types": ["npm-asset", "bower-asset"],
    "installer-paths": {
      "web/libraries/{$name}": [
        "type:drupal-library",
        "type:npm-asset",
        "type:bower-asset"
      ]
    }
  }
}
```

Install the composer-installers-extender package:

```bash
composer require oomphinc/composer-installers-extender
```

#### Step 2: Install the AG-Grid Library

```bash
composer require npm-asset/ag-grid-community:33.0.0
```

This installs the library to `web/libraries/ag-grid-community`.

#### Step 3: Enable the Module

```bash
drush en eb_ui eb_aggrid -y
drush cr
```

**Features:**

- Excel-like spreadsheet interface
- Tabbed editing (Bundles, Fields, Field Groups, Displays)
- Real-time validation with visual feedback
- Smart defaults and auto-generation
- Keyboard shortcuts for efficiency
- Debug mode for troubleshooting

### Field Group Extension (eb_field_group)

Adds support for organizing fields into visual groups.

```bash
# Requires field_group contrib module
composer require drupal/field_group
drush en field_group eb_field_group -y
```

**Adds:**

- `field_group_definitions` array in YAML
- `form_group` / `view_group` properties on fields
- Support for fieldset, details, tabs, and HTML elements

### Pathauto Extension (eb_pathauto)

Adds URL alias pattern configuration to bundles.

```bash
# Requires pathauto contrib module
composer require drupal/pathauto
drush en pathauto eb_pathauto -y
```

**Adds:**

- `pathauto_pattern` property on bundles

### Auto Entity Label Extension (eb_auto_entitylabel)

Adds automatic label generation configuration.

```bash
# Requires auto_entitylabel contrib module
composer require drupal/auto_entitylabel
drush en auto_entitylabel eb_auto_entitylabel -y
```

**Adds:**

- `auto_entitylabel_status` property on bundles
- `auto_entitylabel_pattern` property on bundles

## Post-Installation Configuration

### 1. Set Permissions

Navigate to **People > Permissions** (`/admin/people/permissions`) and configure:

**Tier 3: Administrator**

| Permission | Description |
|------------|-------------|
| `administer entity builder` | Full administrative access |

**Tier 2: Privileged Operations**

| Permission | Description |
|------------|-------------|
| `apply entity definitions` | Apply definitions created in the UI |
| `import entity architecture` | Import and apply YAML files from filesystem |
| `export entity architecture` | Export full site architecture to YAML |
| `rollback entity operations` | Rollback previously executed operations |

**Tier 1: User Permissions**

| Permission | Description |
|------------|-------------|
| `create entity definitions` | Create new definitions |
| `edit own entity definitions` | Edit definitions you created |
| `view own entity definitions` | View definitions you created |
| `delete own entity definitions` | Delete definitions you created |
| `export entity definitions` | Export own definitions to YAML |
| `preview entity definitions` | Preview changes without applying |

### 2. Configure Settings

Navigate to **Configuration > Development > Entity Builder > Settings**:

| Setting | Default | Description |
|---------|---------|-------------|
| Debug Mode | Off | Enable detailed logging |
| Log Operations | On | Log all operations to watchdog |
| Enable Preview | On | Show preview before applying |
| Import Max File Size | 5 MB | Maximum import file size |
| Rollback Retention | 30 days | How long to keep rollback data |

### 3. Verify Installation

Run the discovery command to verify all services are working:

```bash
drush eb:discovery
```

Expected output shows available field types, widgets, and formatters.

## Upgrading

### Minor Version Updates

```bash
composer update drupal/eb
drush updb -y
drush cr
```

### Major Version Updates

1. Review the CHANGELOG for breaking changes
2. Backup your database
3. Update via Composer
4. Run database updates
5. Clear caches
6. Test existing definitions

```bash
composer update drupal/eb
drush updb -y
drush cr
drush eb:validate /path/to/your/definitions/*.yml
```

## Uninstallation

!!! warning "Data Loss Warning"
    Uninstalling will remove all EbDefinition config entities and rollback data.

```bash
# Uninstall extensions first
drush pmu eb_field_group eb_pathauto eb_auto_entitylabel eb_ui -y

# Uninstall core module
drush pmu eb -y
```

## Troubleshooting

### Module Dependencies

If you see dependency errors:

```bash
# Check for missing dependencies
composer why-not drupal/field_group

# Install missing dependencies
composer require drupal/field_group
```

### AG-Grid Library Issues

If eb_aggrid's grid interface doesn't load:

1. Verify the library is installed:
   ```bash
   ls web/libraries/ag-grid-community
   ```

2. If the library is missing, ensure Asset Packagist is configured (see [eb_aggrid installation](#entity-builder-ag-grid-eb_aggrid))

3. Install or reinstall the library:
   ```bash
   composer require npm-asset/ag-grid-community:33.0.0
   ```

4. Check browser console for JavaScript errors

### Cache Issues

If changes aren't appearing:

```bash
drush cr
drush entity-updates  # If available
```

### Service Errors

If you see service-related errors after installation:

```bash
# Rebuild the service container
drush cr

# Check module status
drush pm:list --filter=eb
```
