# Operations Reference

Complete reference for Entity Builder operations.

## Core Operations

### Bundle Operations

#### create_bundle

Creates a new bundle (content type, vocabulary, media type).

**Generated from:**
```yaml
bundle_definitions:
  - entity_type: node
    bundle_id: article
    label: Article
    description: Blog articles
```

**Supports:** Rollback (deletes the created bundle)

#### update_bundle

Updates an existing bundle's configuration.

**Trigger:** Sync mode detects changes in label or settings.

**Supports:** Rollback (restores original values)

#### delete_bundle

Deletes a bundle and all its content.

!!! warning
    This is a destructive operation. All content of this bundle will be deleted.

**Supports:** Limited rollback (bundle recreated but content lost)

### Field Operations

#### create_field

Creates field storage and field instance.

**Generated from:**
```yaml
field_definitions:
  - entity_type: node
    bundle: article
    field_name: field_body
    field_type: text_long
    label: Body
```

**Behavior:**

- Creates field storage if it doesn't exist
- Reuses existing storage if compatible
- Creates field instance on the bundle

**Supports:** Rollback (deletes field instance, optionally storage)

#### update_field

Updates field configuration.

**Updatable properties:**

- label
- description
- required
- default_value
- field_config_settings

**Not updatable:**

- field_type (requires delete + create)
- field_storage_settings (requires delete + create)

**Supports:** Rollback (restores original values)

#### delete_field

Deletes a field instance.

**Behavior:**

- Deletes field instance
- Deletes field storage if no other instances exist

**Supports:** Rollback (recreates field)

#### hide_field

Hides a field from a display without deleting it.

**Generated from:**
```yaml
display_field_definitions:
  - entity_type: node
    bundle: article
    display_type: view
    mode: teaser
    field_name: field_body
    hidden: true
```

#### reorder_fields

Changes the display order of fields.

### Display Operations

#### configure_form_mode

Configures widget settings for a field on a form display.

**Generated from:**
```yaml
field_definitions:
  - entity_type: node
    bundle: article
    field_name: field_body
    widget: text_textarea
    widget_settings:
      rows: 10
```

**Supports:** Rollback (restores original settings)

#### configure_view_mode

Configures formatter settings for a field on a view display.

**Generated from:**
```yaml
field_definitions:
  - entity_type: node
    bundle: article
    field_name: field_body
    formatter: text_default
    formatter_settings:
      trim_length: 200
```

**Supports:** Rollback (restores original settings)

### Menu Operations

#### create_menu

Creates a custom menu.

**Generated from:**
```yaml
menu_definitions:
  - menu_id: main_nav
    label: Main Navigation
    description: Primary site navigation
```

**Supports:** Rollback (deletes menu)

#### create_menu_link

Creates a menu link.

**Supports:** Rollback (deletes link)

## Extension Operations

### Field Group Operations (eb_field_group)

#### create_field_group

Creates a field group on a display.

**Generated from:**
```yaml
field_group_definitions:
  - entity_type: node
    bundle: article
    display_type: form
    mode: default
    group_name: group_content
    label: Content
    format_type: fieldset
```

**Supports:** Rollback (deletes group)

#### update_field_group

Updates field group configuration.

**Supports:** Rollback (restores original)

#### delete_field_group

Deletes a field group.

**Supports:** Rollback (recreates group)

### Pathauto Operations (eb_pathauto)

#### create_pathauto_pattern

Creates a URL alias pattern for a bundle.

**Generated from:**
```yaml
bundle_definitions:
  - entity_type: node
    bundle_id: article
    label: Article
    pathauto_pattern: /blog/[node:title]
```

**Supports:** Rollback (deletes pattern)

### Auto Entity Label Operations (eb_auto_entitylabel)

#### configure_auto_entitylabel

Configures automatic label generation for a bundle.

**Generated from:**
```yaml
bundle_definitions:
  - entity_type: node
    bundle_id: article
    label: Article
    auto_entitylabel_status: enabled
    auto_entitylabel_pattern: "[node:created:date:short] - [node:title]"
```

**Supports:** Rollback (restores original config)

## Operation Lifecycle

```mermaid
flowchart TB
    subgraph Build["Build Phase"]
        Data[Operation Data] --> Instance[Plugin Instance]
    end

    subgraph Validate["Validation Phase"]
        Instance --> OwnValidate[Operation Validate]
        OwnValidate --> PluginValidate[Validator Plugins]
    end

    subgraph Execute["Execution Phase"]
        PluginValidate --> PreEvent[Pre-Execute Event]
        PreEvent --> Execute[Execute]
        Execute --> PostEvent[Post-Execute Event]
        PostEvent --> StoreRollback[Store Rollback Data]
    end
```

## Operation Results

### ExecutionResult

Returned by `execute()`:

```php
$result = new ExecutionResult(TRUE);
$result->addMessage('Field created successfully.');
$result->addAffectedEntity([
    'type' => 'field_config',
    'id' => 'node.article.field_body',
    'label' => 'Body',
]);
$result->setRollbackData([
    'field_id' => 'node.article.field_body',
    'was_new' => TRUE,
]);
```

### RollbackResult

Returned by `rollback()`:

```php
$result = new RollbackResult(TRUE);
$result->addMessage('Field deleted.');
$result->addRestoredEntity([
    'type' => 'field_config',
    'id' => 'node.article.field_body',
]);
```

## Dependency Resolution

Operations are automatically ordered based on dependencies:

| Operation | Depends On |
|-----------|------------|
| `create_field` | `create_bundle` |
| `create_field` (entity_reference) | Target bundle |
| `configure_form_mode` | `create_field` |
| `configure_view_mode` | `create_field` |
| `create_field_group` | Bundle, display, child fields |
| `create_menu_link` | `create_menu` |
| `create_pathauto_pattern` | `create_bundle` |
| `configure_auto_entitylabel` | `create_bundle` |
