# Quick Start Guide

Get up and running with Entity Builder in under 5 minutes.

## Prerequisites

- Drupal 11.x
- PHP 8.3+
- Composer

## Installation

```bash
# Install Entity Builder and dependencies
composer require drupal/eb drupal/eb_aggrid drupal/eb_field_group drupal/eb_pathauto drupal/eb_auto_entitylabel

# Install AG-Grid library (requires Asset Packagist - see Installation Guide)
composer require npm-asset/ag-grid-community:33.0.0

# Enable all modules
drush en eb eb_ui eb_aggrid eb_field_group eb_pathauto eb_auto_entitylabel field_group pathauto auto_entitylabel -y

# Clear cache
drush cr
```

!!! tip "Recommended: AG-Grid Interface"
    The `eb_aggrid` module provides a powerful spreadsheet-like AG-Grid interface for managing definitions. **Strongly recommended** for the best visual editing experience. Requires the AG-Grid library via [Asset Packagist](https://asset-packagist.org/) - see [Installation Guide](installation.md#entity-builder-ag-grid-eb_aggrid) for setup.

## Quick Start

### Step 1: Navigate to Entity Builder

Go to **Configuration > Development > Entity Builder** (`/admin/config/development/eb`)

### Step 2: Create a New Definition

1. Click **Add definition**
2. Enter a **Label** (e.g., "Blog Architecture")
3. The **ID** will auto-generate from the label

### Step 3: Define Bundles

Click the **Bundles** tab to add content types, vocabularies, or media types:

| Entity Type | Bundle ID | Label | Description |
|-------------|-----------|-------|-------------|
| taxonomy_term | blog_category | Blog Categories | Categories for blog posts |
| node | blog_post | Blog Post | Blog articles |

### Step 4: Define Fields

Click the **Fields** tab to add fields to your bundles:

| Entity Type | Bundle | Field Name | Field Type | Label | Widget | Formatter |
|-------------|--------|------------|------------|-------|--------|-----------|
| node | blog_post | field_category | entity_reference | Category | options_select | entity_reference_label |
| node | blog_post | field_image | image | Featured Image | image_image | image |
| node | blog_post | field_summary | text_long | Summary | text_textarea | text_default |

### Step 5: Define Field Groups (Optional)

If you have `eb_field_group` enabled, click the **Field Groups** tab to organize fields into tabs, fieldsets, or accordions.

### Step 6: Validate, Preview, Apply

1. Click **Validate** to check for errors
2. Click **Preview** to see planned operations
3. Click **Apply** to execute

---

## Demo: Job Board Platform

Optionally, import a complete Job Board Platform example to explore Entity Builder features:

```bash
drush eb:import web/modules/custom/eb/tests/fixtures/examples/job_board_platform.yml && drush cr
```

Then visit `/admin/config/development/eb`, click **Job Board Platform**, and click **Apply**.

This creates 7 taxonomies, 4 content types, 60+ fields, 40+ field groups, URL patterns, and auto-generated labels. Study the YAML at `tests/fixtures/examples/job_board_platform.yml`.

---

## Re-Running Definitions (Smart Sync)

Entity Builder uses **smart sync** - you can safely re-run definitions:

- **New items**: Created
- **Changed items**: Updated
- **Unchanged items**: Skipped

---

## Next Steps

- [Core Concepts](concepts.md) - Understand the architecture
- [YAML Format Reference](yaml-format.md) - Complete YAML specification
- [Operations Guide](operations.md) - All available operations
- [AG-Grid Extension](../modules/eb_aggrid/index.md) - Spreadsheet-like interface
- [Field Group Extension](../modules/eb_field_group/index.md) - Tabbed forms and fieldsets
- [Pathauto Extension](../modules/eb_pathauto/index.md) - URL alias patterns
- [Auto Entity Label Extension](../modules/eb_auto_entitylabel/index.md) - Automatic titles
- [Drush Commands](drush.md) - Full CLI reference

## Troubleshooting

### "Field type not found" Error

```bash
composer require drupal/datetime && drush en datetime -y
```

### "Bundle already exists" Error

In `sync` mode, existing bundles are updated. Use `create_only` mode to fail on duplicates.

### Permission Denied

```bash
drush role:perm:add administrator "administer entity builder"
```

### Validation Errors in UI

- Hover over red-highlighted cells for error details
- Check that entity types and bundles exist
- Verify field type compatibility with widgets/formatters
