## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Configuration
- Features
- Maintainers


## INTRODUCTION

Entity Builder UI provides the base user interface for Entity Builder
definitions, including a YAML editor fallback and grid provider discovery
system. It serves as the foundation for visual editing interfaces.

The primary use case for this module is to:

- **YAML Editor** - Provide a CodeMirror-enhanced YAML textarea for editing
  definitions
- **Grid Provider System** - Discover and manage alternative UI providers
  (like AG-Grid)
- **API Endpoints** - Shared AJAX endpoints for validation, preview, and
  entity discovery
- **Source View** - Allow switching between visual and source editing


## REQUIREMENTS

This module requires the following:

- [Entity Builder](https://www.drupal.org/project/eb) (`eb`)


## INSTALLATION

The installation of this module is like other Drupal modules.

1. Enable the module:
   ```bash
   drush en eb_ui -y
   ```

2. Navigate to `/admin/config/development/eb` to use the interface.

For the recommended AG-Grid spreadsheet interface, also install:
```bash
drush en eb_aggrid -y
```


## CONFIGURATION

No additional configuration is required. The module automatically detects
available grid providers.


## FEATURES

### YAML Editor

When no grid provider is available (or when viewing source), the module
provides a CodeMirror-enhanced YAML editor with:

- Syntax highlighting
- Line numbers
- Error indication

### Grid Provider Discovery

The module implements a hook-based discovery system for alternative UI
providers:

```php
#[Hook('eb_ui_grid_provider_info')]
public function gridProviderInfo(): array {
  return [
    'my_provider' => [
      'id' => 'my_provider',
      'label' => $this->t('My Grid Provider'),
      'form_class' => '\Drupal\my_module\Form\MyGridForm',
      'library' => 'my_module/grid',
    ],
  ];
}
```

### Shared API Endpoints

The module provides shared AJAX endpoints used by all grid providers:

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/eb/api/validate` | POST | Validate YAML/JSON content |
| `/eb/api/preview` | POST | Generate operation preview |
| `/eb/api/bundles/{entity_type}` | GET | Get bundles for entity type |
| `/eb/api/entity-config/{entity_type}/{bundle}` | GET | Get field config |

### Source View Toggle

When a grid provider (like AG-Grid) is active, a "Source" link allows
switching to the YAML editor. This enables both visual and source editing
of the same definition.


## MAINTAINERS

Current maintainers:

- lexsoft - https://www.drupal.org/u/lexsoft
