<?php

declare(strict_types=1);

namespace Drupal\eb_ui\Service;

/**
 * Interface for grid provider management.
 *
 * This service discovers grid providers via hook_eb_ui_grid_provider_info()
 * and determines which provider is active based on settings.
 */
interface GridProviderManagerInterface {

  /**
   * Gets all available grid providers.
   *
   * @return array<string, array<string, mixed>>
   *   Array of provider definitions keyed by provider ID. Each definition
   *   contains:
   *   - id: Provider machine name.
   *   - label: Human-readable label.
   *   - form_class: Fully qualified class name of the provider's form.
   *   - library: Library to attach (e.g., 'eb_aggrid/grid').
   *   - theme_class: CSS class for theming (e.g., 'ag-theme-quartz').
   */
  public function getAvailableProviders(): array;

  /**
   * Gets the active grid provider based on settings.
   *
   * @return array<string, mixed>|null
   *   The active provider definition, or NULL if YAML mode is active
   *   or no providers are available.
   */
  public function getActiveProvider(): ?array;

  /**
   * Determines if YAML mode is active.
   *
   * YAML mode is active when:
   * - editor_mode setting is 'yaml', OR
   * - editor_mode is 'auto' and no providers are available.
   *
   * @return bool
   *   TRUE if YAML mode is active, FALSE otherwise.
   */
  public function isYamlMode(): bool;

}
