<?php

declare(strict_types=1);

namespace Drupal\eb\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\eb\PluginInterfaces\OperationInterface;
use Drupal\eb\Result\ExecutionResult;

/**
 * Event dispatched after operation execution.
 */
final class OperationPostExecuteEvent extends Event {

  /**
   * Constructor.
   *
   * @param \Drupal\eb\PluginInterfaces\OperationInterface $operation
   *   The operation that was executed.
   * @param \Drupal\eb\Result\ExecutionResult $result
   *   The execution result.
   */
  public function __construct(
    protected OperationInterface $operation,
    protected ExecutionResult $result,
  ) {}

  /**
   * Gets the operation.
   */
  public function getOperation(): OperationInterface {
    return $this->operation;
  }

  /**
   * Gets the execution result.
   */
  public function getResult(): ExecutionResult {
    return $this->result;
  }

}
