<?php

declare(strict_types=1);

namespace Drupal\eb\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\eb\PluginInterfaces\OperationInterface;
use Drupal\eb\Result\ValidationResult;

/**
 * Event dispatched after operation validation.
 */
final class OperationPostValidateEvent extends Event {

  /**
   * Constructor.
   *
   * @param \Drupal\eb\PluginInterfaces\OperationInterface $operation
   *   The operation that was validated.
   * @param \Drupal\eb\Result\ValidationResult $result
   *   The validation result.
   */
  public function __construct(
    protected OperationInterface $operation,
    protected ValidationResult $result,
  ) {}

  /**
   * Gets the operation.
   */
  public function getOperation(): OperationInterface {
    return $this->operation;
  }

  /**
   * Gets the validation result.
   */
  public function getResult(): ValidationResult {
    return $this->result;
  }

}
