<?php

declare(strict_types=1);

namespace Drupal\eb\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\eb\PluginInterfaces\OperationInterface;

/**
 * Event dispatched before operation execution.
 */
final class OperationPreExecuteEvent extends Event {

  /**
   * Whether execution should be cancelled.
   */
  protected bool $cancelled = FALSE;

  /**
   * Cancellation message.
   */
  protected string $cancellationMessage = '';

  /**
   * Constructor.
   *
   * @param \Drupal\eb\PluginInterfaces\OperationInterface $operation
   *   The operation being executed.
   */
  public function __construct(
    protected OperationInterface $operation,
  ) {}

  /**
   * Gets the operation.
   */
  public function getOperation(): OperationInterface {
    return $this->operation;
  }

  /**
   * Cancels execution.
   *
   * @param string $message
   *   Cancellation message.
   */
  public function cancel(string $message): void {
    $this->cancelled = TRUE;
    $this->cancellationMessage = $message;
  }

  /**
   * Checks if execution is cancelled.
   */
  public function isCancelled(): bool {
    return $this->cancelled;
  }

  /**
   * Gets the cancellation message.
   */
  public function getCancellationMessage(): string {
    return $this->cancellationMessage;
  }

}
