<?php

declare(strict_types=1);

namespace Drupal\eb\Exception;

/**
 * Exception thrown when a requested plugin is not found.
 */
class PluginNotFoundException extends \RuntimeException {

  /**
   * Constructor.
   *
   * @param string $pluginId
   *   The plugin ID that was not found.
   * @param string $pluginType
   *   The plugin type (operation, validator, mapper, format).
   * @param int $code
   *   Exception code.
   * @param \Throwable|null $previous
   *   Previous exception.
   */
  public function __construct(
    protected string $pluginId,
    protected string $pluginType,
    int $code = 0,
    ?\Throwable $previous = NULL,
  ) {
    $message = sprintf(
      'Plugin "%s" of type "%s" was not found.',
      $pluginId,
      $pluginType
    );
    parent::__construct($message, $code, $previous);
  }

  /**
   * Gets the plugin ID.
   */
  public function getPluginId(): string {
    return $this->pluginId;
  }

  /**
   * Gets the plugin type.
   */
  public function getPluginType(): string {
    return $this->pluginType;
  }

}
