<?php

declare(strict_types=1);

namespace Drupal\eb\Exception;

/**
 * Exception thrown when operation rollback fails.
 */
class RollbackException extends \RuntimeException {

  /**
   * Constructor.
   *
   * @param string $message
   *   Exception message.
   * @param array<string, mixed> $context
   *   Additional context about the rollback failure.
   * @param int $code
   *   Exception code.
   * @param \Throwable|null $previous
   *   Previous exception.
   */
  public function __construct(
    string $message = '',
    protected array $context = [],
    int $code = 0,
    ?\Throwable $previous = NULL,
  ) {
    parent::__construct($message, $code, $previous);
  }

  /**
   * Gets the rollback context.
   *
   * @return array<string, mixed>
   *   Context array with rollback details.
   */
  public function getContext(): array {
    return $this->context;
  }

}
