<?php

declare(strict_types=1);

namespace Drupal\eb\PluginInterfaces;

use Drupal\eb\Result\PreviewResult;

/**
 * Interface for operations that support preview functionality.
 *
 * Operations implementing this interface can generate a preview of what
 * changes will be made before execution. This allows users to review
 * the impact of an operation before committing to it.
 *
 * @see \Drupal\eb\Service\PreviewGenerator
 */
interface PreviewableOperationInterface extends OperationInterface {

  /**
   * Generates a preview of what the operation will do.
   *
   * @return \Drupal\eb\Result\PreviewResult
   *   Preview result showing what will be created, modified, or deleted.
   */
  public function preview(): PreviewResult;

}
