<?php

namespace Drupal\eb\PluginManager;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\eb\Attribute\EbValidator;
use Drupal\eb\PluginInterfaces\ValidatorInterface;

/**
 * Plugin manager for Entity Builder validator plugins.
 */
class EbValidatorPluginManager extends DefaultPluginManager {

  /**
   * Constructor.
   *
   * @param \Traversable<string, mixed> $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cacheBackend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $moduleHandler
   *   The module handler.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cacheBackend,
    ModuleHandlerInterface $moduleHandler,
  ) {
    parent::__construct(
      'Plugin/EbValidator',
      $namespaces,
      $moduleHandler,
      ValidatorInterface::class,
      EbValidator::class
    );

    $this->alterInfo('eb_validator_info');
    $this->setCacheBackend($cacheBackend, 'eb_validator_plugins');
  }

}
