<?php

namespace Drupal\eb\Service;

use Drupal\eb\PluginInterfaces\OperationInterface;

/**
 * Interface for the operation builder service.
 *
 * The operation builder creates operation plugin instances from data arrays.
 * It acts as a factory for operations, abstracting the plugin manager.
 */
interface OperationBuilderInterface {

  /**
   * Build an operation from data.
   *
   * @param string $operation_id
   *   The operation plugin ID.
   * @param array<string, mixed> $data
   *   Operation data.
   *
   * @return \Drupal\eb\PluginInterfaces\OperationInterface
   *   The operation instance.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   *   If the operation plugin cannot be instantiated.
   */
  public function buildOperation(string $operation_id, array $data): OperationInterface;

  /**
   * Build multiple operations from a batch of data.
   *
   * @param array<array<string, mixed>> $batch_data
   *   Array of operation data arrays. Each array must contain an 'operation'
   *   or 'operation_type' key specifying the operation plugin ID.
   *
   * @return array<\Drupal\eb\PluginInterfaces\OperationInterface>
   *   Array of operation instances.
   */
  public function buildBatch(array $batch_data): array;

  /**
   * Get available operation types.
   *
   * @return array<string, mixed>
   *   Array of operation plugin definitions.
   */
  public function getAvailableOperations(): array;

  /**
   * Check if an operation type exists.
   *
   * @param string $operation_id
   *   The operation plugin ID.
   *
   * @return bool
   *   TRUE if the operation exists.
   */
  public function operationExists(string $operation_id): bool;

}
