<?php

namespace Drupal\eb\Service;

/**
 * Interface for building operation data arrays from definition data.
 */
interface OperationDataBuilderInterface {

  /**
   * Checks if data is in definition format (vs already-converted operations).
   *
   * Definition format has keys like 'bundle_definitions', 'field_definitions'.
   * Operation format is an array of arrays with 'operation' key.
   *
   * @param array<int|string, mixed> $data
   *   The data to check. May have string keys (definition format) or
   *   integer keys (operation format).
   *
   * @return bool
   *   TRUE if data is in definition format, FALSE if in operations format.
   */
  public function isDefinitionFormat(array $data): bool;

  /**
   * Builds operation data from definition-format array.
   *
   * This is the single source of truth for converting definition data
   * (from UI or EbDefinition entity) into operation arrays
   * for validation and execution.
   *
   * @param array<string, array<int, array<string, mixed>>> $data
   *   Data with keys: bundle_definitions, field_definitions,
   *   field_group_definitions, display_field_definitions, menu_definitions.
   *
   * @return array<int, array<string, mixed>>
   *   Array of operation data arrays.
   */
  public function build(array $data): array;

}
