## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Configuration
- Maintainers


## INTRODUCTION

Entity Builder AG-Grid provides a spreadsheet-like user interface for the
Entity Builder module using AG-Grid Community. Users can define bundles,
fields, field groups, and display configurations using an Excel-like grid
interface instead of writing YAML manually.

This module is a **grid provider** for the `eb_ui` module.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/eb_aggrid).

To submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/eb_aggrid).


## REQUIREMENTS

This module requires the following:

- [Entity Builder](https://www.drupal.org/project/eb) (`drupal/eb`)
- Entity Builder UI (`eb_ui` submodule of `drupal/eb`)
- AG-Grid Community library (33.0.0) via
  [Asset Packagist](https://asset-packagist.org/)


## INSTALLATION

### 1. Configure Asset Packagist

Add the following to your project's root `composer.json`:

```json
{
  "repositories": [
    {"type": "composer", "url": "https://asset-packagist.org"}
  ],
  "extra": {
    "installer-types": ["npm-asset", "bower-asset"],
    "installer-paths": {
      "web/libraries/{$name}": ["type:npm-asset", "type:bower-asset"]
    }
  }
}
```

Then install the extender package:

```bash
composer require oomphinc/composer-installers-extender
```

### 2. Install the Module and Library

```bash
composer require drupal/eb_aggrid npm-asset/ag-grid-community:33.0.0
drush en eb_aggrid -y
```

### 3. Verify

Navigate to `/admin/config/development/eb` to access the spreadsheet interface.


## CONFIGURATION

Configure settings at `/admin/config/development/eb/eb_aggrid/settings`.


## MAINTAINERS

Current maintainers:

- lexsoft - https://www.drupal.org/u/lexsoft
