<?php

namespace Drupal\eb_aggrid\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for eb_aggrid module.
 */
class EbAggridHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_eb_ui_grid_provider_info().
   *
   * @return array<string, array<string, mixed>>
   *   Provider definition array.
   */
  #[Hook('eb_ui_grid_provider_info')]
  public function gridProviderInfo(): array {
    return [
      'aggrid' => [
        'id' => 'aggrid',
        'label' => $this->t('AG-GRID Spreadsheet'),
        'form_class' => '\Drupal\eb_aggrid\Form\EbAggridForm',
        'library' => 'eb_aggrid/grid',
        'theme_class' => 'ag-theme-quartz',
      ],
    ];
  }

}
