<?php

namespace Drupal\eb_aggrid\Service;

/**
 * Interface for building JSON form schemas for field type settings.
 *
 * This service converts Drupal field type settings into JSON schemas
 * that can be rendered as forms in the JavaScript UI.
 */
interface FieldTypeFormSchemaBuilderInterface {

  /**
   * Get the form schema for a specific field type.
   *
   * @param string $fieldType
   *   The field type plugin ID (e.g., 'string', 'entity_reference').
   *
   * @return array<string, array<string, array<string, mixed>>>
   *   Schema with 'storage' and 'config' sections, each containing
   *   field definitions with type, label, description, default, etc.
   */
  public function getFormSchema(string $fieldType): array;

  /**
   * Get form schemas for all available field types.
   *
   * @return array<string, array<string, array<string, array<string, mixed>>>>
   *   Schemas keyed by field type ID.
   */
  public function getAllFormSchemas(): array;

  /**
   * Get default settings values for a field type.
   *
   * Extracts default values from the form schema for use when
   * creating new fields.
   *
   * @param string $fieldType
   *   The field type plugin ID.
   *
   * @return array<string, array<string, mixed>>|null
   *   Array with 'storage' and 'config' default values, or NULL if
   *   no schema exists for this field type.
   */
  public function getDefaultSettings(string $fieldType): ?array;

}
