# ECA Breadcrumbs

ECA module for customizing breadcrumbs with token support.

## Features

### ECA Event
- **Build breadcrumb**: Triggered when a breadcrumb is being built

### ECA Actions

#### Add breadcrumb item
Add an item to the breadcrumb.
- **Title**: Link title (supports tokens)
- **URL**: Link URL (optional, empty = current page)

#### Set breadcrumb items
Replaces the entire breadcrumb with custom items.
Format: One item per line `Title|URL`

Example:
```
Home|/
Products|/products
[node:title]|
```

## Token Support

Both actions support tokens from ECA:
- `[node:title]` - Node title
- `[node:url]` - Node URL
- `[current-page:title]` - Current page title
- `[user:name]` - User name
- And all other available tokens

## Installation

```bash
make drush en eca_breadcrumbs
```

## Usage

1. Create an ECA model
2. Add the "Build breadcrumb" event
3. Add a condition if needed (e.g., content type, route name)
4. Add an "Add breadcrumb item" or "Set breadcrumb items" action
5. Configure titles and URLs with tokens as needed

## Examples

### Custom breadcrumb for a content type

Event: Build breadcrumb
Condition: Node is of type "article"
Action: Set breadcrumb items
```
Home|/
Articles|/articles
[node:title]|
```

### Add a dynamic item

Event: Build breadcrumb
Action: Add breadcrumb item
- Title: `[node:field_category:entity:name]`
- URL: `/category/[node:field_category:entity:id]`

## MAINTAINERS

Current maintainers:

- Fabien Clément - [goz](https://www.drupal.org/u/goz)

Supporting organizations:

- [IOSAN](https://www.drupal.org/iosan)
