<?php

namespace Drupal\eca_breadcrumbs\Event;

use Drupal\Core\Routing\RouteMatchInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched when checking if breadcrumb builder applies.
 */
class BreadcrumbAppliesEvent extends Event {

  /**
   * The event name.
   */
  const EVENT_NAME = 'eca_breadcrumbs.applies';

  /**
   * The route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected RouteMatchInterface $routeMatch;

  /**
   * Whether the breadcrumb builder should apply.
   *
   * @var bool|null
   */
  protected ?bool $applies = NULL;

  /**
   * Constructs a BreadcrumbAppliesEvent object.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   */
  public function __construct(RouteMatchInterface $route_match) {
    $this->routeMatch = $route_match;
  }

  /**
   * Gets the route match.
   *
   * @return \Drupal\Core\Routing\RouteMatchInterface
   *   The route match.
   */
  public function getRouteMatch(): RouteMatchInterface {
    return $this->routeMatch;
  }

  /**
   * Sets whether the breadcrumb builder should apply.
   *
   * @param bool $applies
   *   TRUE if the builder should apply, FALSE otherwise.
   */
  public function setApplies(bool $applies): void {
    $this->applies = $applies;
  }

  /**
   * Gets whether the breadcrumb builder should apply.
   *
   * @return bool|null
   *   TRUE if the builder should apply, FALSE if not, NULL if not set.
   */
  public function getApplies(): ?bool {
    return $this->applies;
  }

  /**
   * Checks if the applies value has been set.
   *
   * @return bool
   *   TRUE if applies has been set.
   */
  public function hasAppliesValue(): bool {
    return $this->applies !== NULL;
  }

}
