# ECA Breadcrumbs

ECA module for customizing breadcrumbs with token support.

## Features

### ECA Events

#### Does breadcrumb should apply
Triggered when Drupal checks if this breadcrumb builder should handle the
current route.
- Use the "Does breadcrumb should apply" action to control when your breadcrumb
pipeline activates
- **Important**: The "Build breadcrumb" event will only fire if this event
returns TRUE

#### Build breadcrumb
Triggered when a breadcrumb is being built.
- **Only fires if the "Does breadcrumb should apply" event returned TRUE**
- Use actions to add or set breadcrumb items

### ECA Actions

#### Does breadcrumb should apply
Controls whether this breadcrumb builder should apply for the current route.
- **Applies**: Check to activate this breadcrumb for the route
- **Pipeline identifier**: Unique identifier for this pipeline
  - Use same identifier in "Build breadcrumb" condition for pipeline isolation
  - Supports tokens

#### Add breadcrumb item
Add an item to the breadcrumb.
- **Title**: Link title (supports tokens)
- **URL**: Link URL (optional, empty = current page)

#### Set breadcrumb items
Replaces the entire breadcrumb with custom items.
Format: One item per line `Title|URL`

Example:
```
Home|/
Products|/products
[node:title]|
```

### ECA Condition

#### Breadcrumb pipeline is active
Checks if a specific pipeline is active in the build event.
- **Pipeline identifier**: Required. Must match the identifier from the action
  - Supports tokens
- Use in the "Build breadcrumb" event to ensure only your pipeline executes

## Token Support

Both actions support tokens from ECA:
- `[node:title]` - Node title
- `[node:url]` - Node URL
- `[current-page:title]` - Current page title
- `[user:name]` - User name
- And all other available tokens

## Installation

```bash
make drush en eca_breadcrumbs
```

## Pipeline Isolation

When you have multiple ECA models managing different breadcrumbs, you need to
ensure each pipeline only builds its own breadcrumb. This is done using the
**pipeline identifier system**.

### How Pipeline Identifiers Work

1. **In the "Does breadcrumb should apply" event:**
   - Add action: "Does breadcrumb should apply" (Applies = TRUE)
   - Set **Pipeline identifier** to a unique value (e.g., "products_breadcrumb")

2. **In the "Build breadcrumb" event:**
   - Add condition: "Breadcrumb pipeline is active"
   - Set **Pipeline identifier** to the same value as step 1

### Why This Matters

Without pipeline identifiers, when ANY pipeline says "applies = TRUE", ALL
"Build breadcrumb" events fire across all ECA models, causing breadcrumbs to mix
together. Pipeline identifiers ensure isolation: only the pipeline that said
"applies = TRUE" will execute its build actions.

## Usage

### Basic Setup (Single Breadcrumb Pipeline)

1. Create an ECA model
2. Add the **"Does breadcrumb should apply"** event
   - Add conditions (e.g., content type = article)
   - Add action: "Does breadcrumb should apply"
     - Applies = TRUE
     - Identifier = `articles_breadcrumb`
3. Add the **"Build breadcrumb"** event
   - Add condition: "Breadcrumb pipeline is active"
     - Identifier = `articles_breadcrumb`
   - Add actions: "Add breadcrumb item" or "Set breadcrumb items"
   - Configure titles and URLs with tokens as needed

### Multiple Breadcrumb Pipelines

When managing different breadcrumbs for different routes:

**Model A** (for products):
- Event: "Does breadcrumb should apply"
  - Condition: Content type is `product`
  - Action: "Does breadcrumb should apply"
    - Applies = TRUE
    - Identifier = `products_breadcrumb`
- Event: "Build breadcrumb"
  - Condition: "Breadcrumb pipeline is active"
    - Identifier = `products_breadcrumb`
  - Actions: Build product breadcrumb

**Model B** (for articles):
- Event: "Does breadcrumb should apply"
  - Condition: Content type is `article`
  - Action: "Does breadcrumb should apply"
    - Applies = TRUE
    - Identifier = `articles_breadcrumb`
- Event: "Build breadcrumb"
  - Condition: "Breadcrumb pipeline is active"
    - Identifier = `articles_breadcrumb`
  - Actions: Build article breadcrumb

This ensures each pipeline only builds its own breadcrumb without interference.

## Examples

### Example 1: Custom breadcrumb for a content type

**Event: "Does breadcrumb should apply"**
- Condition: Node is of type "article"
- Action: "Does breadcrumb should apply" (Applies = TRUE, Identifier = `articles_bc`)

**Event: "Build breadcrumb"**
- Condition: "Breadcrumb pipeline is active" (Identifier = `articles_bc`)
- Action: Set breadcrumb items
```
Home|/
Articles|/articles
[node:title]|
```

### Example 2: Add a dynamic item based on category

**Event: "Does breadcrumb should apply"**
- Condition: Node has field_category
- Action: "Does breadcrumb should apply" (Applies = TRUE, Identifier = `category_bc`)

**Event: "Build breadcrumb"**
- Condition: "Breadcrumb pipeline is active" (Identifier = `category_bc`)
- Action: Add breadcrumb item
  - Title: `Home`
  - URL: `/`
- Action: Add breadcrumb item
  - Title: `[node:field_category:entity:name]`
  - URL: `/category/[node:field_category:entity:id]`
- Action: Add breadcrumb item
  - Title: `[node:title]`
  - URL: (empty = current page)

## MAINTAINERS

Current maintainers:

- Fabien Clément - [goz](https://www.drupal.org/u/goz)

Supporting organizations:

- [IOSAN](https://www.drupal.org/iosan)
