<?php

namespace Drupal\eca_breadcrumbs\Plugin\ECA\Event;

use Drupal\eca\Plugin\ECA\Event\EventBase;
use Drupal\eca_breadcrumbs\Event\BreadcrumbAppliesEvent;
use Drupal\eca_breadcrumbs\Event\BreadcrumbBuildEvent;

/**
 * Plugin implementation of the ECA Events for breadcrumbs.
 *
 * @EcaEvent(
 *   id = "eca_breadcrumbs",
 *   deriver = "Drupal\eca_breadcrumbs\Plugin\ECA\Event\BreadcrumbEventDeriver",
 *   eca_version_introduced = "1.0.0"
 * )
 *
 * @phpstan-ignore-next-line
 */
class EcaBreadcrumbsEvents extends EventBase {

  /**
   * {@inheritdoc}
   */
  public static function definitions(): array {
    return [
      'applies' => [
        'label' => 'Does breadcrumb should apply',
        'event_name' => BreadcrumbAppliesEvent::EVENT_NAME,
        'event_class' => BreadcrumbAppliesEvent::class,
      ],
      'build' => [
        'label' => 'Build breadcrumb',
        'event_name' => BreadcrumbBuildEvent::EVENT_NAME,
        'event_class' => BreadcrumbBuildEvent::class,
      ],
    ];
  }

}
