# ECA Breadcrumbs

ECA module for customizing breadcrumbs with token support.

## Features

### ECA Events

#### Build breadcrumb
Triggered when a breadcrumb is being built.
- Use condition to define if breadcrumb has to be built
- Use actions to add or set breadcrumb items

### ECA Actions

#### Add breadcrumb item
Add an item to the breadcrumb.
- **Title**: Link title (supports tokens)
- **URL**: Link URL (optional, empty = current page)

#### Set breadcrumb items
Replaces the entire breadcrumb with custom items.
Format: One item per line `Title|URL`

Example:
```
Home|/
Products|/products
[node:title]|
```

### ECA Condition

## Token Support

Both actions support tokens from ECA:
- `[node:title]` - Node title
- `[node:url]` - Node URL
- `[current-page:title]` - Current page title
- `[user:name]` - User name
- And all other available tokens

## Installation

```bash
make drush en eca_breadcrumbs
```

## Usage

### Basic Setup

1. Create an ECA model
2. Add the **"Build breadcrumb"** event
   - Add condition: based on route or path for example.
   - Add actions: "Add breadcrumb item" or "Set breadcrumb items"
   - Configure titles and URLs with tokens as needed

## Examples

### Example 1: Custom breadcrumb for a content type

**Event: "Build breadcrumb"**
- Condition: Node is of type "article"
- Action: Set breadcrumb items
```
Home|/
Articles|/articles
[node:title]|
```

### Example 2: Add a dynamic item based on category

**Event: "Build breadcrumb"**
- Condition: Node has field_category
- Action: Add breadcrumb item
  - Title: `Home`
  - URL: `/`
- Action: Add breadcrumb item
  - Title: `[node:field_category:entity:name]`
  - URL: `/category/[node:field_category:entity:id]`
- Action: Add breadcrumb item
  - Title: `[node:title]`
  - URL: (empty = current page)

## MAINTAINERS

Current maintainers:

- Fabien Clément - [goz](https://www.drupal.org/u/goz)

Supporting organizations:

- [IOSAN](https://www.drupal.org/iosan)
