<?php

namespace Drupal\eca_breadcrumbs\Plugin\Action;

use Drupal\Core\Form\FormStateInterface;

/**
 * Add a breadcrumb item.
 *
 * @Action(
 *   id = "eca_breadcrumbs_add_item",
 *   label = @Translation("Breadcrumb: add item"),
 *   type = "breadcrumb"
 * )
 */
class AddBreadcrumbItem extends BreadcrumbActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL): void {
    $event = $this->getBreadcrumbEvent();
    if (!$event) {
      return;
    }

    $title = $this->configuration['title'] ?? '';
    $url = $this->configuration['url'] ?? '';

    if (empty($title)) {
      return;
    }

    // Prepare token data and replace tokens.
    $this->prepareTokenData($event);
    $title = $this->tokenService->replaceClear($title);
    $url = $this->tokenService->replaceClear($url);

    // Add the item.
    $event->addItem($title, $url ?: NULL);
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return [
      'title' => '',
      'url' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['title'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Title'),
      '#description' => $this->t('The breadcrumb link title. Supports tokens.'),
      '#default_value' => $this->configuration['title'],
      '#required' => TRUE,
      '#weight' => 10,
    ];

    $form['url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('URL'),
      '#description' => $this->t('The link URL (e.g., /products or https://example.com). Leave empty for current page. Supports tokens.'),
      '#default_value' => $this->configuration['url'],
      '#weight' => 20,
    ];

    return parent::buildConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->configuration['title'] = $form_state->getValue('title');
    $this->configuration['url'] = $form_state->getValue('url');
    parent::submitConfigurationForm($form, $form_state);
  }

}
