<?php

namespace Drupal\eca_breadcrumbs;

use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\eca\Token\TokenInterface;

/**
 * Helper service for managing token data in breadcrumb actions.
 */
class TokenDataHelper {

  /**
   * The ECA token service.
   *
   * @var \Drupal\eca\Token\TokenInterface
   */
  protected TokenInterface $tokenService;

  /**
   * Constructs a TokenDataHelper object.
   *
   * @param \Drupal\eca\Token\TokenInterface $token_service
   *   The ECA token service.
   */
  public function __construct(TokenInterface $token_service) {
    $this->tokenService = $token_service;
  }

  /**
   * Adds route parameters to ECA token data.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   */
  public function addRouteParametersToTokenData(RouteMatchInterface $route_match): void {
    // Add all route parameters to ECA token service.
    foreach ($route_match->getParameters() as $name => $value) {
      if (is_object($value) && method_exists($value, 'getEntityTypeId')) {
        // Add entity using its type as token name.
        $this->tokenService->addTokenData($value->getEntityTypeId(), $value);
      }
      elseif ($value !== NULL) {
        // Add scalar values.
        $this->tokenService->addTokenData($name, $value);
      }
    }
  }

}
