<?php

namespace Drupal\eca_cm;

use Drupal\Core\Extension\ModuleExtensionList;

/**
 * Helper to determine certain information regarding the installed ECA version.
 */
final class EcaInfo {

  /**
   * Get the service instance of this class.
   *
   * @return self
   */
  public static function service(): self {
    return \Drupal::service(self::class);
  }

  public function __construct(
    private ModuleExtensionList $extensionList
  ) {}

  /**
   * @return bool
   */
  public function usesModelerApi(): bool {
    $extension = $this->extensionList->get('eca_ui');
    if ($extension) {
      $dependencies = $extension->info['dependencies'] ?? [];
      return in_array('modeler_api:modeler_api', $dependencies, TRUE);
    }
    return FALSE;
  }

}
