<?php

namespace Drupal\eca_content_access\Plugin\Action;

use Drupal\Core\Action\Attribute\Action;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\eca\Attribute\EcaAction;

/**
 * Revoke content access from a node entity for a role.
 */
#[Action(
  id: 'eca_content_access_revoke_access',
  label: new TranslatableMarkup('Content access: revoke access'),
  type: 'node',
)]
#[EcaAction(
  description: new TranslatableMarkup('Revokes access from an individual node for a role to overwrite settings of the content type.'),
  version_introduced: '1.0.0',
)]
class RevokeAccess extends GrantAccess {

  /**
   * {@inheritdoc}
   */
  protected function updateSettings(array &$bundleSettings, string $operation, string $role): bool {
    if (!isset($bundleSettings[$operation]) || !in_array($role, $bundleSettings[$operation], TRUE)) {
      // The role already has no access to that operation, nothing to change.
      return FALSE;
    }
    $bundleSettings[$operation] = array_diff($bundleSettings[$operation], [$role]);
    return TRUE;
  }

}
