# ECA Entity Import

A Drupal module that provides an ECA (Event-Condition-Action) migrate process plugin for entity imports,
enabling advanced automation and workflow integration during entity import processes.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/eca_entity_import).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/eca_entity_import).


## Table of contents

- Overview
- Features
- Requirements
- Installation
- Configuration
- Usage
- Troubleshooting
- Changelog
- Maintainers


## Overview

The ECA Entity Import module bridges the gap between the Entity Import module and ECA
by providing a specialized migrate process plugin. This allows you to trigger ECA models
during entity import operations, enabling complex business logic, validation, transformation,
and automation workflows.


## Features

- **ECA Integration**: Seamlessly integrate ECA models with entity import processes
- **Importer ID Tracking**: Access the entity importer ID within ECA models via tokens
- **Event-Driven Processing**: Trigger custom workflows based on entity import events
- **Zero Configuration**: Simple setup with no complex configuration requirements
- **Error Handling**: Robust error handling with user-friendly messages


## Requirements

- **Drupal**: ^11.2
- **Migrate**: Core migrate module
- **Entity Import**: [Entity Import module](https://www.drupal.org/project/entity_import)
- **ECA Migrate**: [ECA module](https://www.drupal.org/project/eca) with migrate support (>=3.0.3)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration


### Basic Setup

1. **Enable the Module**: Ensure all dependencies are installed and enable the ECA Entity Import module.

2. **Configure Entity Import**: Set up your entity import configuration using the Entity Import module.

3. **Add ECA Process Plugin**: In your entity import field mappings, add the "ECA" process plugin to any field.


### Process Plugin Configuration

The ECA process plugin has no additional configuration options. Simply select "ECA" from the list of
available process plugins in your entity import field mapping.


## Usage


### Accessing Import Data in ECA Models

When the ECA process plugin is active, the following token is available within your ECA models:

- `row:source:importer_id` - Contains the ID of the current entity importer


### Example Use Cases

#### 1. Conditional Processing Based on Importer

```yaml
# ECA Model Configuration
event: Processing migration row value
  - Token name holding the processed value: processed_value
condition: Compare two scalar values
  - First value: '[row:source:importer_id]'
  - Comparison operator: 'equals'
  - Second value: #your specific importer id
actions: # Your custom logic here
```

#### 2. Logging Import Activities

```yaml
# ECA Model Configuration
event: Processing migration row value
  - Token name holding the processed value: processed_value
actions:
  - plugin: Log Message
    Type: 'ECA entity import'
    Severity: 'info'
    Message: 'Processing import from: [row:source:importer_id]'
```


## Troubleshooting


### Common Issues

#### Plugin Not Available
##### Problem
The ECA process plugin doesn't appear in the field mapping options.

##### Solution
Ensure all dependencies are installed and the module is enabled.

#### Token Not Working
##### Problem
The `row:source:importer_id` token returns empty values.

##### Solution
Verify the ECA process plugin is added to at least one field mapping in your entity import configuration.

#### ECA Model Not Triggering
##### Problem
ECA models aren't executing during import.

##### Solution
1. Check that your ECA model is enabled
2. Verify the event configuration matches the import process
3. Ensure conditions are properly configured


## Changelog


### 1.0.0
- Initial release
- ECA process plugin implementation
- Comprehensive test coverage


## Maintainers

- Richard Papp - [boromino](https://www.drupal.org/u/boromino)
