# ECA External Workflows: Pipedream Provider

This module provides Pipedream integration for the ECA External Workflows system.

## Overview

This is a provider module for the ECA External Workflows infrastructure that enables integration with [Pipedream](https://pipedream.com), a workflow automation platform.

## Requirements

- **ECA External Workflows** (`eca_external_workflows`) - Main infrastructure module
- **Key module** (`key`) - For secure API key storage
- **ECA** (`eca`) - For workflow integration

## Features

- **Webhook Execution**: Trigger Pipedream workflows via webhook URLs
- **API Integration**: Optional API key authentication for advanced operations
- **Multiple Auth Methods**: Support for public webhooks, API keys, and signatures
- **Error Handling**: Comprehensive error detection and reporting
- **Execution Tracking**: Unique execution ID extraction when available

## Installation

1. Ensure the main `eca_external_workflows` module is installed and enabled
2. Install this module as you would any Drupal contrib module
3. Configure API keys (optional) using the Key module

## Configuration

### Basic Webhook Usage (No Authentication)
```yaml
provider: pipedream
workflow_id: https://abc123.m.pipedream.net/webhook-path
payload_data: |
  {
    "name": "[current-user:display-name]",
    "email": "[current-user:mail]",
    "action": "user_login"
  }
```

### Authenticated Requests
```yaml
provider: pipedream
workflow_id: https://abc123.m.pipedream.net/webhook-path
workflow_config: |
  authentication:
    api_key: "your_pipedream_api_key"
  timeout: 30
  retry_attempts: 3
payload_data: |
  {
    "name": "[current-user:display-name]",
    "email": "[current-user:mail]"
  }
```

## Webhook URL Format

Pipedream webhook URLs follow this pattern:
- `https://*.m.pipedream.net/*`

Example: `https://abc123.m.pipedream.net/webhook-path`

## Supported Operations

- **webhook**: Execute workflows via HTTP POST to webhook URLs
- **api**: Advanced operations using Pipedream API (requires API key)

## Error Handling

The provider extracts error information from Pipedream responses and provides structured error tokens for ECA workflow continuation.

## Security

- All webhook URLs must use HTTPS
- API keys are stored securely using the Key module
- Optional webhook signature validation for enhanced security

## Maintainers

This module follows the architectural patterns established in the main ECA External Workflows module.
