<?php

declare(strict_types=1);

namespace Drupal\eca_external_workflows;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\eca_external_workflows\Attribute\ExternalWorkflowProvider;

/**
 * ExternalWorkflowProvider plugin manager.
 */
final class ExternalWorkflowProviderPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/ExternalWorkflowProvider', $namespaces, $module_handler, ExternalWorkflowProviderInterface::class, ExternalWorkflowProvider::class);
    $this->alterInfo('external_workflow_provider_info');
    $this->setCacheBackend($cache_backend, 'external_workflow_provider_plugins');
  }

}
