# ECA: Google

This module allows you to integrate Google services with your Drupal site
using ECA's visual workflow builder. Create workflows that respond to events
on your site by interacting with Google services, or trigger Drupal actions
based on changes in your Google data.

## Features

#### Current Google Services Supported:
- **Google Sheets** - Read, write, query, and manage spreadsheet data

#### Planned Google Services:
- **Google Meet** - Video conferencing automation
- **Google Calendar** - Event and scheduling automation

## Installation

### Install API modules
For all services connected with this suite of modules, you will need to install the
[Google API PHP Client module](https://www.drupal.org/project/google_api_client)
and the included ECA: Google module.

### Configure Google Authentication
After installing the API modules, you must configure your Google authentication. This
module supports API key and Service Account methods for authentication.

- Create a project in [Google Cloud Console](https://console.cloud.google.com/), and
enable the APIs that you want to use with your Drupal site. (e.g. Sheets, Meet, etc.)
- Decide if you will use API key or service account authentication, and create the required
credentials in your Google Cloud project.
- Enter your credentials on your Drupal site. To set up API key authentication,
  go to `/admin/config/services/google_api_client`. To set up Service Account
  authentication, go to `/admin/config/services/google_api_service_client`.

### Install the service submodules
Once you've completed setup of the credentials, install the service submodules
from this suite that match the APIs you enabled in your project.
(e.g. ECA: Google Sheets, ECA: Google Meet)
