<?php

namespace Drupal\eca_google_sheets;

use Drupal\Core\Form\FormStateInterface;
use Drupal\eca_google\GoogleAuthActionConfigTrait;

trait GoogleSheetsActionConfigTrait {

  protected function getSpreadsheetIdDefaultConfig() : array {
    return ['spreadsheet_id' => '',];
  }

  protected function getSheetRangeDefaultConfig() : array {
    return ['sheet_range' => 'Sheet1'];
  }

  protected function addSpreadsheetIdConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['spreadsheet_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Spreadsheet ID'),
      '#description' => $this->t('The Google Spreadsheet ID (from the URL). Supports token replacement.'),
      '#default_value' => $this->configuration['spreadsheet_id'],
      '#eca_token_replacement' => TRUE,
      '#required' => TRUE,
    ];

    return $form;
  }

  protected function addSheetRangeConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['sheet_range'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Sheet Range'),
      '#description' => $this->t('The sheet name or range (e.g., "Sheet1", "Data!A1:C1"). Supports token replacement.'),
      '#default_value' => $this->configuration['sheet_range'],
      '#eca_token_replacement' => TRUE,
      '#required' => TRUE,
    ];
    return $form;
  }

  protected function validateSheetsAccess(array $form, FormStateInterface $form_state) : void {
    if (!empty($auth_client_id)) {
      [$auth_type, $client_id] = explode(':', $auth_client_id, 2);

      if (!in_array($auth_type, ['api_client', 'service_account'])) {
        $form_state->setErrorByName('auth_client_id', $this->t('Auth type must be "oauth" or "service_account".'));
        return;
      }

      // Validate API access.
      if (!$this->googleSheetsService->validateApiAccess($auth_type, $client_id)) {
        $form_state->setErrorByName('auth_client_id', $this->t('The specified client does not have required Sheets API access.'));
      }
    }
  }

}
